/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.deployers.processors;

import org.jboss.as.connector.ConnectorServices;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterXmlDeploymentService;
import org.jboss.as.connector.metadata.xmldescriptors.ConnectorXmlDescriptor;
import org.jboss.as.connector.registry.ResourceAdapterDeploymentRegistry;
import org.jboss.as.connector.subsystems.jca.JcaSubsystemConfiguration;
import org.jboss.as.naming.service.NamingService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapter;
import org.jboss.jca.common.api.metadata.resourceadapter.ResourceAdapters;
import org.jboss.jca.core.api.connectionmanager.ccm.CachedConnectionManager;
import org.jboss.jca.core.api.management.ManagementRepository;
import org.jboss.jca.core.spi.mdr.MetadataRepository;
import org.jboss.jca.core.spi.rar.ResourceAdapterRepository;
import org.jboss.jca.core.spi.transaction.TransactionIntegration;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.SubjectFactory;

public class RaXmlDeploymentProcessor
implements DeploymentUnitProcessor {
    public static final Logger log = Logger.getLogger((String)"org.jboss.as.connector.deployer.raxmldeployer");
    private final MetadataRepository mdr;

    public RaXmlDeploymentProcessor(MetadataRepository mdr) {
        this.mdr = mdr;
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ConnectorXmlDescriptor connectorXmlDescriptor = (ConnectorXmlDescriptor)deploymentUnit.getAttachment(ConnectorXmlDescriptor.ATTACHMENT_KEY);
        if (connectorXmlDescriptor == null) {
            return;
        }
        ResourceAdapters raxmls = null;
        ServiceController raService = phaseContext.getServiceRegistry().getService(ConnectorServices.RESOURCEADAPTERS_SERVICE);
        if (raService != null) {
            raxmls = (ResourceAdapters)raService.getValue();
        }
        if (raxmls == null) {
            return;
        }
        log.tracef("processing Raxml", new Object[0]);
        Module module = (Module)deploymentUnit.getAttachment(Attachments.MODULE);
        if (module == null) {
            throw new DeploymentUnitProcessingException("Failed to get module attachment for " + deploymentUnit);
        }
        try {
            ServiceTarget serviceTarget = phaseContext.getServiceTarget();
            for (ResourceAdapter raxml : raxmls.getResourceAdapters()) {
                if (!deploymentUnit.getName().equals(raxml.getArchive())) continue;
                String deployment = deploymentUnit.getName().lastIndexOf(46) == -1 ? deploymentUnit.getName() : deploymentUnit.getName().substring(0, deploymentUnit.getName().lastIndexOf(46));
                ResourceAdapterXmlDeploymentService service = new ResourceAdapterXmlDeploymentService(connectorXmlDescriptor, raxml, module, deployment);
                serviceTarget.addService(ConnectorServices.RESOURCE_ADAPTER_XML_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()}), (Service)service).addDependency(ConnectorServices.IRONJACAMAR_MDR, MetadataRepository.class, service.getMdrInjector()).addDependency(ConnectorServices.RA_REPOSISTORY_SERVICE, ResourceAdapterRepository.class, service.getRaRepositoryInjector()).addDependency(ConnectorServices.MANAGEMENT_REPOSISTORY_SERVICE, ManagementRepository.class, service.getManagementRepositoryInjector()).addDependency(ConnectorServices.RESOURCE_ADAPTER_REGISTRY_SERVICE, ResourceAdapterDeploymentRegistry.class, service.getRegistryInjector()).addDependency(ConnectorServices.TRANSACTION_INTEGRATION_SERVICE, TransactionIntegration.class, service.getTxIntegrationInjector()).addDependency(ConnectorServices.CONNECTOR_CONFIG_SERVICE, JcaSubsystemConfiguration.class, service.getConfigInjector()).addDependency(SubjectFactoryService.SERVICE_NAME, SubjectFactory.class, service.getSubjectFactoryInjector()).addDependency(ConnectorServices.CCM_SERVICE, CachedConnectionManager.class, service.getCcmInjector()).addDependency(NamingService.SERVICE_NAME).addDependencies(new ServiceName[]{ConnectorServices.RESOURCE_ADAPTER_SERVICE_PREFIX.append(new String[]{connectorXmlDescriptor.getDeploymentName()})}).setInitialMode(ServiceController.Mode.ACTIVE).install();
            }
        }
        catch (Throwable t) {
            throw new DeploymentUnitProcessingException(t);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

