/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.client.helpers.domain.impl;

import org.jboss.as.controller.client.helpers.domain.RollbackDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentPlanBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.DeploymentSetPlanImpl;
import org.jboss.as.controller.client.helpers.domain.impl.InitialDeploymentSetBuilderImpl;
import org.jboss.as.controller.client.helpers.domain.impl.RollbackDeploymentPlanBuilderImpl;

class ServerGroupDeploymentPlanBuilderImpl
extends InitialDeploymentSetBuilderImpl
implements ServerGroupDeploymentPlanBuilder {
    ServerGroupDeploymentPlanBuilderImpl(DeploymentPlanBuilderImpl existing, DeploymentSetPlanImpl setPlan) {
        super(existing, setPlan);
    }

    @Override
    public RollbackDeploymentPlanBuilder withRollback() {
        DeploymentSetPlanImpl setPlan = this.getCurrentDeploymentSetPlan();
        ServerGroupDeploymentPlan groupPlan = setPlan.getLatestServerGroupDeploymentPlan();
        if (groupPlan == null) {
            throw new IllegalStateException(String.format("No %s is configured", ServerGroupDeploymentPlan.class.getSimpleName()));
        }
        groupPlan = groupPlan.createRollback();
        setPlan = setPlan.storeServerGroup(groupPlan);
        return new RollbackDeploymentPlanBuilderImpl((DeploymentPlanBuilderImpl)this, setPlan);
    }

    @Override
    public ServerGroupDeploymentPlanBuilder rollingToServers() {
        DeploymentSetPlanImpl setPlan = this.getCurrentDeploymentSetPlan();
        ServerGroupDeploymentPlan groupPlan = setPlan.getLatestServerGroupDeploymentPlan();
        if (groupPlan == null) {
            throw new IllegalStateException(String.format("No %s is configured", ServerGroupDeploymentPlan.class.getSimpleName()));
        }
        groupPlan = groupPlan.createRollingToServers();
        setPlan = setPlan.storeServerGroup(groupPlan);
        return new ServerGroupDeploymentPlanBuilderImpl((DeploymentPlanBuilderImpl)this, setPlan);
    }

    @Override
    public ServerGroupDeploymentPlanBuilder rollingToServerGroup(String serverGroupName) {
        DeploymentSetPlanImpl setPlan = this.getCurrentDeploymentSetPlan();
        ServerGroupDeploymentPlan groupPlan = new ServerGroupDeploymentPlan(serverGroupName);
        setPlan = setPlan.storeRollToServerGroup(groupPlan);
        return new ServerGroupDeploymentPlanBuilderImpl((DeploymentPlanBuilderImpl)this, setPlan);
    }

    @Override
    public ServerGroupDeploymentPlanBuilder toServerGroup(String serverGroupName) {
        DeploymentSetPlanImpl setPlan = this.getCurrentDeploymentSetPlan();
        ServerGroupDeploymentPlan groupPlan = new ServerGroupDeploymentPlan(serverGroupName);
        setPlan = setPlan.storeServerGroup(groupPlan);
        return new ServerGroupDeploymentPlanBuilderImpl((DeploymentPlanBuilderImpl)this, setPlan);
    }
}

