/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.EnumMap;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceContainer;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartException;

public abstract class BootstrapListener
extends AbstractServiceListener<Object> {
    private final AtomicInteger started = new AtomicInteger();
    private final AtomicInteger failed = new AtomicInteger();
    private final AtomicInteger outstanding = new AtomicInteger();
    private final AtomicBoolean done = new AtomicBoolean();
    private final AtomicInteger missingDeps = new AtomicInteger();
    private final EnumMap<ServiceController.Mode, AtomicInteger> map;
    private final ServiceContainer serviceContainer;
    private final Set<ServiceName> missingDepsSet = Collections.synchronizedSet(new TreeSet());
    private final ServiceTarget serviceTarget;
    private final long startTime;
    private volatile boolean cancelLikely;

    public BootstrapListener(ServiceContainer serviceContainer, long startTime, ServiceTarget serviceTarget) {
        this.serviceContainer = serviceContainer;
        this.startTime = startTime;
        this.serviceTarget = serviceTarget;
        EnumMap<ServiceController.Mode, AtomicInteger> map = new EnumMap<ServiceController.Mode, AtomicInteger>(ServiceController.Mode.class);
        for (ServiceController.Mode mode : ServiceController.Mode.values()) {
            map.put(mode, new AtomicInteger());
        }
        this.map = map;
    }

    public void listenerAdded(ServiceController<?> controller) {
        ServiceController.Mode mode = controller.getMode();
        if (mode == ServiceController.Mode.ACTIVE) {
            this.outstanding.incrementAndGet();
        } else {
            controller.removeListener((ServiceListener)this);
        }
        this.map.get(mode).incrementAndGet();
    }

    public void serviceStarted(ServiceController<?> controller) {
        this.started.incrementAndGet();
        controller.removeListener((ServiceListener)this);
        this.tick();
    }

    public void serviceFailed(ServiceController<?> controller, StartException reason) {
        this.failed.incrementAndGet();
        controller.removeListener((ServiceListener)this);
        this.tick();
    }

    public void dependencyFailed(ServiceController<? extends Object> controller) {
        controller.removeListener((ServiceListener)this);
        this.tick();
    }

    public void immediateDependencyAvailable(ServiceController<? extends Object> controller) {
        this.missingDepsSet.remove(controller.getName());
    }

    public void immediateDependencyUnavailable(ServiceController<? extends Object> controller) {
        this.missingDepsSet.add(controller.getName());
    }

    public void dependencyProblem(ServiceController<? extends Object> controller) {
        this.missingDeps.incrementAndGet();
        this.check();
    }

    public void dependencyProblemCleared(ServiceController<? extends Object> controller) {
        this.missingDeps.decrementAndGet();
        this.check();
    }

    public void serviceRemoved(ServiceController<?> controller) {
        this.cancelLikely = true;
        controller.removeListener((ServiceListener)this);
        this.tick();
    }

    private void check() {
        int outstanding = this.outstanding.get();
        if (outstanding == this.missingDeps.get()) {
            this.finish(this.serviceContainer, outstanding);
        }
    }

    private void tick() {
        int outstanding = this.outstanding.decrementAndGet();
        if (outstanding != this.missingDeps.get()) {
            return;
        }
        this.finish(this.serviceContainer, outstanding);
    }

    private void finish(ServiceContainer container, int outstanding) {
        if (this.done.getAndSet(true)) {
            return;
        }
        this.serviceTarget.removeListener((ServiceListener)this);
        if (this.cancelLikely) {
            return;
        }
        int failed = this.failed.get() + outstanding;
        long elapsedTime = Math.max(System.currentTimeMillis() - this.startTime, 0L);
        int started = this.started.get();
        this.done(container, elapsedTime, started, failed, this.map, this.missingDepsSet);
    }

    protected abstract void done(ServiceContainer var1, long var2, int var4, int var5, EnumMap<ServiceController.Mode, AtomicInteger> var6, Set<ServiceName> var7);
}

