/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.SocketBindingGroupDescription;
import org.jboss.dmr.ModelNode;

public abstract class AbstractSocketBindingGroupRemoveHandler
implements ModelRemoveOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";

    protected AbstractSocketBindingGroupRemoveHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress(operation.require("address"));
        String name = address.getLastElement().getValue();
        ModelNode model = context.getSubModel();
        ModelNode compensating = this.getCompensatingOperation(model, operation);
        return this.uninstallSocketBindingGroup(name, model, context, resultHandler, compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return SocketBindingGroupDescription.getSocketBindingRemoveOperation(locale);
    }

    protected abstract ModelNode getCompensatingOperation(ModelNode var1, ModelNode var2);

    protected OperationResult uninstallSocketBindingGroup(String name, ModelNode model, OperationContext context, ResultHandler resultHandler, ModelNode compensatingOp) {
        resultHandler.handleResultComplete();
        return new BasicOperationResult(compensatingOp);
    }
}

