/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SystemPropertyAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    public static final SystemPropertyAddHandler INSTANCE_WITH_BOOTTIME = new SystemPropertyAddHandler(true);
    public static final SystemPropertyAddHandler INSTANCE_WITHOUT_BOOTTIME = new SystemPropertyAddHandler(false);
    private final ParametersValidator validator = new ParametersValidator();
    private final boolean useBoottime;

    public static ModelNode getOperation(ModelNode address, String value) {
        return SystemPropertyAddHandler.getOperation(address, value, null);
    }

    public static ModelNode getOperation(ModelNode address, String value, Boolean boottime) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        if (value == null) {
            op.get("value").set(new ModelNode());
        } else {
            op.get("value").set(value);
        }
        if (boottime != null) {
            op.get("boot-time").set(boottime.booleanValue());
        }
        return op;
    }

    private SystemPropertyAddHandler(boolean useBoottime) {
        this.useBoottime = useBoottime;
        this.validator.registerValidator("value", new StringLengthValidator(0, true));
        if (useBoottime) {
            this.validator.registerValidator("boot-time", new ModelTypeValidator(ModelType.BOOLEAN, true));
        }
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, final ResultHandler resultHandler) throws OperationFailedException {
        this.validator.validate(operation);
        ModelNode opAddr = operation.require("address");
        final String name = PathAddress.pathAddress(opAddr).getLastElement().getValue();
        final String value = operation.get("value").isDefined() ? operation.get("value").asString() : null;
        ModelNode node = context.getSubModel();
        if (value == null) {
            node.get("value").set(new ModelNode());
        } else {
            node.get("value").set(value);
        }
        if (this.useBoottime) {
            boolean boottime = operation.get("boot-time").isDefined() ? operation.get("boot-time").asBoolean() : true;
            node.get("boot-time").set(boottime);
        }
        ModelNode compensating = Util.getResourceRemoveOperation(opAddr);
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                @Override
                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    SecurityActions.setSystemProperty(name, value);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddSystemPropertyOperation(locale, this.useBoottime);
    }
}

