/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelRemoveOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.common.SecurityActions;
import org.jboss.as.controller.operations.common.SystemPropertyAddHandler;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class SystemPropertyRemoveHandler
implements ModelRemoveOperationHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "remove";
    public static final SystemPropertyRemoveHandler INSTANCE = new SystemPropertyRemoveHandler();

    public static ModelNode getOperation(ModelNode address, String name) {
        ModelNode op = Util.getEmptyOperation(OPERATION_NAME, address);
        op.get("name").set(name);
        return op;
    }

    private SystemPropertyRemoveHandler() {
    }

    @Override
    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode opAddr = operation.require("address");
        String name = PathAddress.pathAddress(opAddr).getLastElement().getValue();
        ModelNode toRemove = context.getSubModel();
        String value = toRemove.hasDefined("value") ? toRemove.get("value").asString() : null;
        Boolean boottime = toRemove.has("boot-time") ? Boolean.valueOf(toRemove.get("boot-time").asBoolean()) : null;
        ModelNode compensating = SystemPropertyAddHandler.getOperation(operation.get("address"), value, boottime);
        return this.removeSystemProperty(name, context, resultHandler, compensating);
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getRemoveSystemPropertyOperation(locale);
    }

    protected OperationResult removeSystemProperty(final String name, OperationContext context, final ResultHandler resultHandler, ModelNode compensating) {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                @Override
                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    SecurityActions.clearSystemProperty(name);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return new BasicOperationResult(compensating);
    }
}

