/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.validation;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;

public class ParametersValidator {
    final Map<String, ParameterValidator> validators = new ConcurrentHashMap<String, ParameterValidator>();

    public ParametersValidator() {
    }

    public ParametersValidator(ParametersValidator toCopy) {
        this.validators.putAll(toCopy.validators);
    }

    public void registerValidator(String parameterName, ParameterValidator validator) {
        this.validators.put(parameterName, validator);
    }

    public void validate(ModelNode operation) throws OperationFailedException {
        for (Map.Entry<String, ParameterValidator> entry : this.validators.entrySet()) {
            String paramName = entry.getKey();
            ModelNode paramVal = operation.has(paramName) ? operation.get(paramName) : new ModelNode();
            entry.getValue().validateParameter(paramName, paramVal);
        }
    }

    public void validateResolved(ModelNode operation) throws OperationFailedException {
        for (Map.Entry<String, ParameterValidator> entry : this.validators.entrySet()) {
            String paramName = entry.getKey();
            ModelNode paramVal = operation.has(paramName) ? operation.get(paramName) : new ModelNode();
            entry.getValue().validateResolvedParameter(paramName, paramVal);
        }
    }
}

