/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.jboss.as.controller.PathElement;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class PathAddress
implements Iterable<PathElement> {
    public static final PathAddress EMPTY_ADDRESS = new PathAddress(Collections.<PathElement>emptyList());
    private final List<PathElement> pathAddressList;

    public static PathAddress pathAddress(ModelNode node) {
        LinkedHashMap<String, PathElement> pathMap;
        if (node.isDefined()) {
            ArrayList<Property> props = new ArrayList<Property>();
            String key = null;
            for (ModelNode element : node.asList()) {
                Property prop = null;
                if (element.getType() == ModelType.PROPERTY || element.getType() == ModelType.OBJECT) {
                    prop = element.asProperty();
                } else if (key == null) {
                    key = element.asString();
                } else {
                    prop = new Property(key, element);
                }
                if (prop == null) continue;
                props.add(prop);
                key = null;
            }
            if (props.size() == 0) {
                return EMPTY_ADDRESS;
            }
            pathMap = new LinkedHashMap<String, PathElement>();
            for (Property prop : props) {
                String name = prop.getName();
                if (pathMap.put(name, new PathElement(name, prop.getValue().asString())) == null) continue;
                throw PathAddress.duplicateElement(name);
            }
        } else {
            return EMPTY_ADDRESS;
        }
        return new PathAddress(Collections.unmodifiableList(new ArrayList(pathMap.values())));
    }

    public static PathAddress pathAddress(List<PathElement> elements) {
        if (elements.size() == 0) {
            return EMPTY_ADDRESS;
        }
        ArrayList<PathElement> newList = new ArrayList<PathElement>(elements.size());
        HashSet<String> seen = new HashSet<String>();
        for (PathElement element : elements) {
            String name = element.getKey();
            if (seen.add(name)) {
                newList.add(element);
                continue;
            }
            throw PathAddress.duplicateElement(name);
        }
        return new PathAddress(Collections.unmodifiableList(newList));
    }

    public static PathAddress pathAddress(PathElement ... elements) {
        return PathAddress.pathAddress(Arrays.asList(elements));
    }

    public static PathAddress pathAddress(PathAddress parent, PathElement ... elements) {
        ArrayList<PathElement> list = new ArrayList<PathElement>(parent.pathAddressList);
        for (PathElement element : elements) {
            list.add(element);
        }
        return PathAddress.pathAddress(list);
    }

    private static IllegalArgumentException duplicateElement(String name) {
        return new IllegalArgumentException("Duplicate path element \"" + name + "\" found");
    }

    PathAddress(List<PathElement> pathAddressList) {
        assert (pathAddressList != null) : "pathAddressList is null";
        this.pathAddressList = pathAddressList;
    }

    public PathElement getElement(int index) {
        List<PathElement> list = this.pathAddressList;
        return list.get(index);
    }

    public PathElement getLastElement() {
        List<PathElement> list = this.pathAddressList;
        return list.size() == 0 ? null : list.get(list.size() - 1);
    }

    public PathAddress subAddress(int start) {
        List<PathElement> list = this.pathAddressList;
        return new PathAddress(list.subList(start, list.size()));
    }

    public PathAddress subAddress(int start, int end) {
        return new PathAddress(this.pathAddressList.subList(start, end));
    }

    public PathAddress append(List<PathElement> additionalElements) {
        ArrayList<PathElement> newList = new ArrayList<PathElement>(this.pathAddressList.size() + additionalElements.size());
        newList.addAll(this.pathAddressList);
        newList.addAll(additionalElements);
        return PathAddress.pathAddress(newList);
    }

    public PathAddress append(PathElement ... additionalElements) {
        return this.append(Arrays.asList(additionalElements));
    }

    public PathAddress append(PathAddress address) {
        return this.append(address.pathAddressList);
    }

    public ModelNode navigate(ModelNode model, boolean create) throws NoSuchElementException {
        Iterator<PathElement> i = this.pathAddressList.iterator();
        while (i.hasNext()) {
            PathElement element = i.next();
            if (create && !i.hasNext()) {
                if (element.isMultiTarget()) {
                    throw new IllegalStateException();
                }
                model = model.require(element.getKey()).get(element.getValue());
                continue;
            }
            model = model.require(element.getKey()).require(element.getValue());
        }
        return model;
    }

    public ModelNode remove(ModelNode model) throws NoSuchElementException {
        Iterator<PathElement> i = this.pathAddressList.iterator();
        while (i.hasNext()) {
            PathElement element = i.next();
            if (i.hasNext()) {
                model = model.require(element.getKey()).require(element.getValue());
                continue;
            }
            ModelNode parent = model.require(element.getKey());
            model = parent.remove(element.getValue()).clone();
        }
        return model;
    }

    public ModelNode toModelNode() {
        ModelNode node = new ModelNode().setEmptyList();
        for (PathElement element : this.pathAddressList) {
            String value = element.isMultiTarget() && !element.isWildcard() ? '[' + element.getValue() + ']' : element.getValue();
            node.add(element.getKey(), value);
        }
        return node;
    }

    public boolean isMultiTarget() {
        for (PathElement element : this.pathAddressList) {
            if (!element.isMultiTarget()) continue;
            return true;
        }
        return false;
    }

    public int size() {
        return this.pathAddressList.size();
    }

    @Override
    public ListIterator<PathElement> iterator() {
        return this.pathAddressList.listIterator();
    }

    public int hashCode() {
        return ((Object)this.pathAddressList).hashCode();
    }

    public boolean equals(Object other) {
        return other instanceof PathAddress && this.equals((PathAddress)other);
    }

    public boolean equals(PathAddress other) {
        return this == other || other != null && ((Object)this.pathAddressList).equals(other.pathAddressList);
    }

    public String toString() {
        return this.toModelNode().toString();
    }
}

