/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;

public final class ContainerStateMonitor
extends AbstractServiceListener<Object> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.controller");
    private final ServiceRegistry serviceRegistry;
    private final ServiceController<?> controllerController;
    private final AtomicInteger busyServiceCount = new AtomicInteger();
    private final Map<ServiceController<?>, String> failedControllers = new IdentityHashMap();
    private final Map<ServiceController<?>, String> latestSettledFailedControllers = new IdentityHashMap();
    private final Map<ServiceController<?>, String> lastReportFailedControllers = new IdentityHashMap();
    private final Set<ServiceController<?>> servicesWithMissingDeps = ContainerStateMonitor.identitySet();
    private Set<ServiceName> previousMissingDepSet = new HashSet<ServiceName>();
    private final Set<ServiceName> lastReportMissingDepSet = new TreeSet<ServiceName>();

    ContainerStateMonitor(ServiceRegistry registry, ServiceController<?> controller) {
        this.serviceRegistry = registry;
        this.controllerController = controller;
    }

    void acquire() {
        this.untick();
    }

    void release() {
        this.tick();
    }

    public void listenerAdded(ServiceController<?> controller) {
        if (controller == this.controllerController) {
            controller.removeListener((ServiceListener)this);
        } else {
            this.untick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
        switch (transition) {
            case STARTING_to_START_FAILED: {
                ContainerStateMonitor containerStateMonitor = this;
                synchronized (containerStateMonitor) {
                    this.failedControllers.put(controller, controller.getStartException().toString());
                    break;
                }
            }
            case REMOVING_to_REMOVED: {
                ContainerStateMonitor containerStateMonitor = this;
                synchronized (containerStateMonitor) {
                    this.failedControllers.remove(controller);
                    this.servicesWithMissingDeps.remove(controller);
                    break;
                }
            }
            case START_FAILED_to_DOWN: 
            case START_FAILED_to_STARTING: {
                ContainerStateMonitor containerStateMonitor = this;
                synchronized (containerStateMonitor) {
                    this.failedControllers.remove(controller);
                    break;
                }
            }
        }
        ServiceController.Substate before = transition.getBefore();
        ServiceController.Substate after = transition.getAfter();
        if (before.isRestState() && !after.isRestState()) {
            this.untick();
        } else if (!before.isRestState() && after.isRestState()) {
            this.tick();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void immediateDependencyAvailable(ServiceController<?> controller) {
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            this.servicesWithMissingDeps.remove(controller);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void immediateDependencyUnavailable(ServiceController<?> controller) {
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            this.servicesWithMissingDeps.add(controller);
        }
    }

    void awaitUninterruptibly() {
        this.awaitUninterruptibly(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void awaitUninterruptibly(int count) {
        boolean intr = false;
        try {
            ContainerStateMonitor containerStateMonitor = this;
            synchronized (containerStateMonitor) {
                while (this.busyServiceCount.get() > count) {
                    try {
                        ((Object)((Object)this)).wait();
                    }
                    catch (InterruptedException e) {
                        intr = true;
                    }
                }
            }
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    void await() throws InterruptedException {
        this.await(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void await(int count) throws InterruptedException {
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            while (this.busyServiceCount.get() > count) {
                ((Object)((Object)this)).wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        int tick = this.busyServiceCount.decrementAndGet();
        ContainerStateMonitor containerStateMonitor = this;
        synchronized (containerStateMonitor) {
            ((Object)((Object)this)).notifyAll();
            if (tick == 0) {
                ServiceController controller;
                HashSet<ServiceName> missingDeps = new HashSet<ServiceName>();
                for (ServiceController<?> controller2 : this.servicesWithMissingDeps) {
                    missingDeps.addAll(controller2.getImmediateUnavailableDependencies());
                }
                Set<ServiceName> previousMissing = this.previousMissingDepSet;
                TreeSet<ServiceName> noLongerMissing = new TreeSet<ServiceName>();
                for (ServiceName name : previousMissing) {
                    if (missingDeps.contains(name)) continue;
                    noLongerMissing.add(name);
                }
                TreeSet<ServiceName> newlyMissing = new TreeSet<ServiceName>();
                newlyMissing.clear();
                for (ServiceName name : missingDeps) {
                    if (previousMissing.contains(name)) continue;
                    newlyMissing.add(name);
                }
                this.previousMissingDepSet = missingDeps;
                this.latestSettledFailedControllers.clear();
                this.latestSettledFailedControllers.putAll(this.failedControllers);
                StringBuilder msg = new StringBuilder();
                msg.append("Service status report\n");
                boolean print = false;
                if (!newlyMissing.isEmpty()) {
                    print = true;
                    msg.append("   New missing/unsatisfied dependencies:\n");
                    for (ServiceName serviceName : newlyMissing) {
                        controller = this.serviceRegistry.getService(serviceName);
                        if (controller == null) {
                            msg.append("      ").append(serviceName).append(" (missing)\n");
                            continue;
                        }
                        msg.append("      ").append(serviceName).append(" (unavailable)\n");
                    }
                }
                if (!noLongerMissing.isEmpty()) {
                    print = true;
                    msg.append("   Newly corrected services:\n");
                    for (ServiceName serviceName : noLongerMissing) {
                        controller = this.serviceRegistry.getService(serviceName);
                        if (controller == null) {
                            msg.append("      ").append(serviceName).append(" (no longer required)\n");
                            continue;
                        }
                        msg.append("      ").append(serviceName).append(" (now available)\n");
                    }
                }
                if (!this.failedControllers.isEmpty()) {
                    print = true;
                    msg.append("  Services which failed to start:\n");
                    for (Map.Entry entry : this.failedControllers.entrySet()) {
                        msg.append("      ").append(((ServiceController)entry.getKey()).getName()).append(": ").append((String)entry.getValue()).append('\n');
                    }
                    this.failedControllers.clear();
                }
                if (print) {
                    log.info((Object)msg);
                }
            }
        }
    }

    private void untick() {
        this.busyServiceCount.incrementAndGet();
    }

    synchronized ModelNode getServerStateChangeReport() {
        IdentityHashMap newFailedControllers = new IdentityHashMap(this.latestSettledFailedControllers);
        newFailedControllers.keySet().removeAll(this.lastReportFailedControllers.keySet());
        this.lastReportFailedControllers.clear();
        this.lastReportFailedControllers.putAll(this.latestSettledFailedControllers);
        TreeSet<ServiceName> newReportMissingDepSet = new TreeSet<ServiceName>(this.previousMissingDepSet);
        newReportMissingDepSet.removeAll(this.lastReportMissingDepSet);
        this.lastReportMissingDepSet.clear();
        this.lastReportMissingDepSet.addAll(this.previousMissingDepSet);
        ModelNode report = null;
        if (!newFailedControllers.isEmpty() || !newReportMissingDepSet.isEmpty()) {
            report = new ModelNode();
            if (!newReportMissingDepSet.isEmpty()) {
                ModelNode missing = report.get("New missing/unsatisfied dependencies");
                for (ServiceName serviceName : newReportMissingDepSet) {
                    ServiceController controller = this.serviceRegistry.getService(serviceName);
                    if (controller == null) {
                        missing.add(serviceName + " (missing)");
                        continue;
                    }
                    missing.add(serviceName + " (unavailable)\n");
                }
            }
            if (!newFailedControllers.isEmpty()) {
                ModelNode failed = report.get("Services which failed to start:");
                for (Map.Entry entry : newFailedControllers.entrySet()) {
                    failed.add(((ServiceController)entry.getKey()).getName().toString());
                }
            }
        }
        return report;
    }

    private static <T> Set<T> identitySet() {
        return Collections.newSetFromMap(new IdentityHashMap());
    }
}

