/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.operations.validation.ParametersValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.dmr.ModelNode;

public abstract class AbstractSocketBindingGroupAddHandler
extends AbstractAddStepHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add";
    private final ParametersValidator validator;

    protected AbstractSocketBindingGroupAddHandler(ParametersValidator validator) {
        this.validator = new ParametersValidator(validator);
        this.validator.registerValidator("default-interface", new StringLengthValidator(1, Integer.MAX_VALUE, true, true));
    }

    @Override
    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.validator.validate(operation);
        PathAddress address = PathAddress.pathAddress(operation.get("address"));
        String name = address.getLastElement().getValue();
        model.get("name").set(name);
        model.get("default-interface").set(operation.get("default-interface"));
        model.get("socket-binding");
    }
}

