/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.common.CommonDescriptions;
import org.jboss.as.controller.operations.validation.ModelTypeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class SchemaLocationAddHandler
extends AbstractModelUpdateHandler
implements DescriptionProvider {
    public static final String OPERATION_NAME = "add-schema-location";
    public static final SchemaLocationAddHandler INSTANCE = new SchemaLocationAddHandler();
    private final ParameterValidator typeValidator = new ModelTypeValidator(ModelType.PROPERTY);

    public static ModelNode getAddSchemaLocationOperation(ModelNode address, Property schemaLocation) {
        ModelNode op = new ModelNode();
        op.get("operation").set(OPERATION_NAME);
        op.get("address").set(address);
        op.get("schema-location").set(schemaLocation);
        return op;
    }

    private SchemaLocationAddHandler() {
    }

    @Override
    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        ModelNode param = operation.get("schema-location");
        ModelNode locations = model.get("schema-locations");
        this.validate(param, locations);
        Property loc = param.asProperty();
        locations.add(loc.getName(), loc.getValue());
    }

    @Override
    protected boolean requiresRuntime(OperationContext context) {
        return false;
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return CommonDescriptions.getAddSchemaLocationOperation(locale);
    }

    private void validate(ModelNode param, ModelNode locations) throws OperationFailedException {
        this.typeValidator.validateParameter("schema-location", param);
        if (locations.isDefined()) {
            String uri = param.asProperty().getName();
            for (ModelNode node : locations.asList()) {
                if (!uri.equals(node.asProperty().getName())) continue;
                throw new OperationFailedException(new ModelNode().set("Schema with URI " + uri + " already registered with location " + node.asProperty().getValue().asString()));
            }
        }
    }
}

