/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.EnumSet;
import java.util.Set;
import org.jboss.as.controller.OperationStepHandler;

public final class AttributeAccess {
    private final AccessType access;
    private final Storage storage;
    private final OperationStepHandler readHandler;
    private final OperationStepHandler writeHandler;
    private final EnumSet<Flag> flags;

    AttributeAccess(AccessType access, Storage storage, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<Flag> flags) {
        assert (access != null) : "access is null";
        assert (storage != null) : "storage is null";
        this.access = access;
        this.readHandler = readHandler;
        this.writeHandler = writeHandler;
        this.storage = storage;
        if (access == AccessType.READ_WRITE && writeHandler == null) {
            throw new IllegalArgumentException("writeHandler is null");
        }
        this.flags = flags == null ? EnumSet.noneOf(Flag.class) : EnumSet.copyOf(flags);
        switch (storage) {
            case CONFIGURATION: {
                this.flags.add(Flag.STORAGE_CONFIGURATION);
                this.flags.remove((Object)Flag.STORAGE_RUNTIME);
                break;
            }
            case RUNTIME: {
                this.flags.add(Flag.STORAGE_RUNTIME);
                this.flags.remove((Object)Flag.STORAGE_CONFIGURATION);
                break;
            }
            default: {
                throw new IllegalStateException("unexpected storage " + (Object)((Object)storage));
            }
        }
    }

    public AccessType getAccessType() {
        return this.access;
    }

    public Storage getStorageType() {
        return this.storage;
    }

    public OperationStepHandler getReadHandler() {
        return this.readHandler;
    }

    public OperationStepHandler getWriteHandler() {
        return this.writeHandler;
    }

    public Set<Flag> getFlags() {
        return EnumSet.copyOf(this.flags);
    }

    public static enum Flag {
        RESTART_NONE,
        RESTART_JVM,
        RESTART_ALL_SERVICES,
        RESTART_RESOURCE_SERVICES,
        STORAGE_CONFIGURATION,
        STORAGE_RUNTIME;

    }

    public static enum Storage {
        CONFIGURATION("configuration"),
        RUNTIME("runtime");

        private final String label;

        private Storage(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }

    public static enum AccessType {
        READ_ONLY("read-only"),
        READ_WRITE("read-write"),
        METRIC("metric");

        private final String label;

        private AccessType(String label) {
            this.label = label;
        }

        public String toString() {
            return this.label;
        }
    }
}

