/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.registry;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProxyController;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.registry.AbstractResourceRegistration;
import org.jboss.as.controller.registry.AtomicMapFieldUpdater;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.NodeSubregistry;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;

final class ConcreteResourceRegistration
extends AbstractResourceRegistration {
    private volatile Map<String, NodeSubregistry> children;
    private volatile Map<String, OperationEntry> operations;
    private volatile DescriptionProvider descriptionProvider;
    private volatile Map<String, AttributeAccess> attributes;
    private final boolean runtimeOnly;
    private static final AtomicMapFieldUpdater<ConcreteResourceRegistration, String, NodeSubregistry> childrenUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ConcreteResourceRegistration.class, Map.class, "children"));
    private static final AtomicMapFieldUpdater<ConcreteResourceRegistration, String, OperationEntry> operationsUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ConcreteResourceRegistration.class, Map.class, "operations"));
    private static final AtomicMapFieldUpdater<ConcreteResourceRegistration, String, AttributeAccess> attributesUpdater = AtomicMapFieldUpdater.newMapUpdater(AtomicReferenceFieldUpdater.newUpdater(ConcreteResourceRegistration.class, Map.class, "attributes"));
    private static final AtomicReferenceFieldUpdater<ConcreteResourceRegistration, DescriptionProvider> descriptionProviderUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcreteResourceRegistration.class, DescriptionProvider.class, "descriptionProvider");

    ConcreteResourceRegistration(String valueString, NodeSubregistry parent, DescriptionProvider provider, boolean runtimeOnly) {
        super(valueString, parent);
        childrenUpdater.clear(this);
        operationsUpdater.clear(this);
        attributesUpdater.clear(this);
        descriptionProviderUpdater.set(this, provider);
        this.runtimeOnly = runtimeOnly;
    }

    @Override
    public boolean isRuntimeOnly() {
        return this.runtimeOnly;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public ManagementResourceRegistration registerSubModel(PathElement address, DescriptionProvider descriptionProvider) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        if (descriptionProvider == null) {
            throw new IllegalArgumentException("descriptionProvider is null");
        }
        if (this.runtimeOnly) {
            throw new IllegalStateException("Cannot register non-runtime-only submodels with a runtime-only parent");
        }
        String key = address.getKey();
        NodeSubregistry child = this.getOrCreateSubregistry(key);
        return child.register(address.getValue(), descriptionProvider, false);
    }

    @Override
    public void registerSubModel(PathElement address, ManagementResourceRegistration subModel) {
        if (address == null) {
            throw new IllegalArgumentException("address is null");
        }
        if (subModel == null) {
            throw new IllegalArgumentException("subModel is null");
        }
        String key = address.getKey();
        NodeSubregistry child = this.getOrCreateSubregistry(key);
        child.register(address.getValue(), subModel);
    }

    @Override
    OperationEntry getOperationEntry(ListIterator<PathElement> iterator, String operationName, OperationEntry inherited) {
        if (iterator.hasNext()) {
            OperationEntry ourInherited = this.getInheritableOperationEntry(operationName);
            OperationEntry inheritance = ourInherited == null ? inherited : ourInherited;
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getOperationEntry(iterator, next.getValue(), operationName, inheritance);
        }
        OperationEntry entry = operationsUpdater.get(this, operationName);
        return entry == null ? inherited : entry;
    }

    @Override
    OperationEntry getInheritableOperationEntry(String operationName) {
        OperationEntry entry = operationsUpdater.get(this, operationName);
        if (entry != null && entry.isInherited()) {
            return entry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void getOperationDescriptions(ListIterator<PathElement> iterator, Map<String, OperationEntry> providers, boolean inherited) {
        if (!iterator.hasNext()) {
            providers.putAll(operationsUpdater.get(this));
            if (inherited) {
                this.getInheritedOperations(providers, true);
            }
            return;
        }
        PathElement next = iterator.next();
        try {
            String key = next.getKey();
            Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
            NodeSubregistry subregistry = snapshot.get(key);
            if (subregistry != null) {
                subregistry.getHandlers(iterator, next.getValue(), providers, inherited);
            }
        }
        finally {
            iterator.previous();
        }
    }

    @Override
    void getInheritedOperationEntries(Map<String, OperationEntry> providers) {
        for (Map.Entry<String, OperationEntry> entry : operationsUpdater.get(this).entrySet()) {
            if (!entry.getValue().isInherited() || providers.containsKey(entry.getKey())) continue;
            providers.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType) {
        if (operationsUpdater.putIfAbsent(this, operationName, new OperationEntry(handler, descriptionProvider, inherited, entryType)) != null) {
            throw new IllegalArgumentException("A handler named '" + operationName + "' is already registered at location '" + this.getLocationString() + "'");
        }
    }

    @Override
    public void registerOperationHandler(String operationName, OperationStepHandler handler, DescriptionProvider descriptionProvider, boolean inherited, OperationEntry.EntryType entryType, EnumSet<OperationEntry.Flag> flags) {
        if (operationsUpdater.putIfAbsent(this, operationName, new OperationEntry(handler, descriptionProvider, inherited, entryType, flags)) != null) {
            throw new IllegalArgumentException("A handler named '" + operationName + "' is already registered at location '" + this.getLocationString() + "'");
        }
    }

    @Override
    public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, AttributeAccess.Storage storage) {
        if (attributesUpdater.putIfAbsent(this, attributeName, new AttributeAccess(AttributeAccess.AccessType.READ_WRITE, storage, readHandler, writeHandler, null)) != null) {
            throw new IllegalArgumentException("An attribute named '" + attributeName + "' is already registered at location '" + this.getLocationString() + "'");
        }
    }

    @Override
    public void registerReadWriteAttribute(String attributeName, OperationStepHandler readHandler, OperationStepHandler writeHandler, EnumSet<AttributeAccess.Flag> flags) {
        AttributeAccess.Storage storage;
        AttributeAccess.Storage storage2 = storage = flags != null && flags.contains((Object)AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION;
        if (attributesUpdater.putIfAbsent(this, attributeName, new AttributeAccess(AttributeAccess.AccessType.READ_WRITE, storage, readHandler, writeHandler, flags)) != null) {
            throw new IllegalArgumentException("An attribute named '" + attributeName + "' is already registered at location '" + this.getLocationString() + "'");
        }
    }

    @Override
    public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, AttributeAccess.Storage storage) {
        if (attributesUpdater.putIfAbsent(this, attributeName, new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, storage, readHandler, null, null)) != null) {
            throw new IllegalArgumentException("An attribute named '" + attributeName + "' is already registered at location '" + this.getLocationString() + "'");
        }
    }

    @Override
    public void registerReadOnlyAttribute(String attributeName, OperationStepHandler readHandler, EnumSet<AttributeAccess.Flag> flags) {
        AttributeAccess.Storage storage;
        AttributeAccess.Storage storage2 = storage = flags != null && flags.contains((Object)AttributeAccess.Flag.STORAGE_RUNTIME) ? AttributeAccess.Storage.RUNTIME : AttributeAccess.Storage.CONFIGURATION;
        if (attributesUpdater.putIfAbsent(this, attributeName, new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, storage, readHandler, null, null)) != null) {
            throw new IllegalArgumentException("An attribute named '" + attributeName + "' is already registered at location '" + this.getLocationString() + "'");
        }
    }

    @Override
    public void registerMetric(String attributeName, OperationStepHandler metricHandler) {
        this.registerMetric(attributeName, metricHandler, null);
    }

    @Override
    public void registerMetric(String attributeName, OperationStepHandler metricHandler, EnumSet<AttributeAccess.Flag> flags) {
        if (attributesUpdater.putIfAbsent(this, attributeName, new AttributeAccess(AttributeAccess.AccessType.METRIC, AttributeAccess.Storage.RUNTIME, metricHandler, null, flags)) != null) {
            throw new IllegalArgumentException("An attribute named '" + attributeName + "' is already registered at location '" + this.getLocationString() + "'");
        }
    }

    @Override
    public void registerProxyController(PathElement address, ProxyController controller) throws IllegalArgumentException {
        this.getOrCreateSubregistry(address.getKey()).registerProxyController(address.getValue(), controller);
    }

    @Override
    public void unregisterProxyController(PathElement address) throws IllegalArgumentException {
        Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
        NodeSubregistry subregistry = snapshot.get(address.getKey());
        if (subregistry != null) {
            subregistry.unregisterProxyController(address.getValue());
        }
    }

    NodeSubregistry getOrCreateSubregistry(String key) {
        NodeSubregistry newRegistry;
        NodeSubregistry appearing;
        do {
            Map<String, NodeSubregistry> snapshot;
            NodeSubregistry subregistry;
            if ((subregistry = (snapshot = childrenUpdater.get(this)).get(key)) != null) {
                return subregistry;
            }
            newRegistry = new NodeSubregistry(key, this);
            appearing = childrenUpdater.putAtomic(this, key, newRegistry, snapshot);
            if (appearing != null) continue;
            return newRegistry;
        } while (appearing == newRegistry);
        return appearing;
    }

    @Override
    DescriptionProvider getModelDescription(Iterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getModelDescription(iterator, next.getValue());
        }
        return this.descriptionProvider;
    }

    @Override
    Set<String> getAttributeNames(Iterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getAttributeNames(iterator, next.getValue());
        }
        Map<String, AttributeAccess> snapshot = attributesUpdater.get(this);
        return snapshot.keySet();
    }

    @Override
    AttributeAccess getAttributeAccess(ListIterator<PathElement> iterator, String attributeName) {
        ModelNode desc;
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getAttributeAccess(iterator, next.getValue(), attributeName);
        }
        Map<String, AttributeAccess> snapshot = attributesUpdater.get(this);
        AttributeAccess access = snapshot.get(attributeName);
        if (access == null && (desc = this.descriptionProvider.getModelDescription(null)).has("attributes") && desc.get("attributes").keys().contains(attributeName)) {
            access = new AttributeAccess(AttributeAccess.AccessType.READ_ONLY, AttributeAccess.Storage.CONFIGURATION, null, null, null);
        }
        return access;
    }

    @Override
    Set<String> getChildNames(Iterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getChildNames(iterator, next.getValue());
        }
        Map<String, NodeSubregistry> children = this.children;
        if (children != null) {
            return Collections.unmodifiableSet(children.keySet());
        }
        return Collections.emptySet();
    }

    @Override
    Set<PathElement> getChildAddresses(Iterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return Collections.emptySet();
            }
            return subregistry.getChildAddresses(iterator, next.getValue());
        }
        Map<String, NodeSubregistry> children = this.children;
        if (children != null) {
            HashSet<PathElement> elements = new HashSet<PathElement>();
            for (Map.Entry<String, NodeSubregistry> entry : children.entrySet()) {
                for (String entryChild : entry.getValue().getChildNames()) {
                    elements.add(PathElement.pathElement(entry.getKey(), entryChild));
                }
            }
            return elements;
        }
        return Collections.emptySet();
    }

    @Override
    ProxyController getProxyController(Iterator<PathElement> iterator) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return null;
            }
            return subregistry.getProxyController(iterator, next.getValue());
        }
        return null;
    }

    @Override
    void getProxyControllers(Iterator<PathElement> iterator, Set<ProxyController> controllers) {
        if (iterator.hasNext()) {
            PathElement next = iterator.next();
            NodeSubregistry subregistry = this.children.get(next.getKey());
            if (subregistry == null) {
                return;
            }
            if (next.isWildcard()) {
                subregistry.getProxyControllers(iterator, null, controllers);
            } else if (next.isMultiTarget()) {
                for (String value : next.getSegments()) {
                    subregistry.getProxyControllers(iterator, value, controllers);
                }
            } else {
                subregistry.getProxyControllers(iterator, next.getValue(), controllers);
            }
        } else {
            Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
            for (NodeSubregistry subregistry : snapshot.values()) {
                subregistry.getProxyControllers(iterator, null, controllers);
            }
        }
    }

    @Override
    ManagementResourceRegistration getResourceRegistration(Iterator<PathElement> iterator) {
        if (!iterator.hasNext()) {
            return this;
        }
        PathElement address = iterator.next();
        Map<String, NodeSubregistry> snapshot = childrenUpdater.get(this);
        NodeSubregistry subregistry = snapshot.get(address.getKey());
        if (subregistry != null) {
            return subregistry.getResourceRegistration(iterator, address.getValue());
        }
        return null;
    }
}

