/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import java.util.Locale;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.RunningMode;
import org.jboss.as.controller.RunningModeControl;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.descriptions.DefaultOperationDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.AbstractServiceListener;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

public class ProcessReloadHandler<T extends RunningModeControl>
implements OperationStepHandler,
DescriptionProvider {
    public static final String OPERATION_NAME = "reload";
    private static final AttributeDefinition ADMIN_ONLY = new SimpleAttributeDefinitionBuilder("admin-only", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false)).build();
    private static final AttributeDefinition RESTART_SERVERS = new SimpleAttributeDefinitionBuilder("restart-servers", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(true)).build();
    private final T runningModeControl;
    private final ControlledProcessState processState;
    private DescriptionProvider descriptionProvider;
    private final ServiceName rootService;
    private final ResourceDescriptionResolver resourceDescriptionResolver;

    public ProcessReloadHandler(ServiceName rootService, T runningModeControl, ControlledProcessState processState, ResourceDescriptionResolver resourceDescriptionResolver) {
        this.rootService = rootService;
        this.runningModeControl = runningModeControl;
        this.processState = processState;
        this.resourceDescriptionResolver = resourceDescriptionResolver;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                final boolean adminOnly = ADMIN_ONLY.resolveModelAttribute(context, operation).asBoolean(false);
                final boolean restartServers = RESTART_SERVERS.resolveModelAttribute(context, operation).asBoolean(true);
                ServiceController service = context.getServiceRegistry(true).getRequiredService(ProcessReloadHandler.this.rootService);
                if (context.completeStep() == OperationContext.ResultAction.KEEP) {
                    service.addListener((ServiceListener)new AbstractServiceListener<Object>(){

                        public void listenerAdded(ServiceController<?> controller) {
                            ProcessReloadHandler.this.reloadInitiated(ProcessReloadHandler.this.runningModeControl, adminOnly, restartServers);
                            ProcessReloadHandler.this.processState.setStopping();
                            controller.setMode(ServiceController.Mode.NEVER);
                        }

                        public void transition(ServiceController<? extends Object> controller, ServiceController.Transition transition) {
                            if (transition == ServiceController.Transition.STOPPING_to_DOWN) {
                                controller.removeListener((ServiceListener)this);
                                ProcessReloadHandler.this.doReload(ProcessReloadHandler.this.runningModeControl, adminOnly, restartServers);
                                controller.setMode(ServiceController.Mode.ACTIVE);
                            }
                        }
                    });
                }
            }
        }, OperationContext.Stage.RUNTIME);
        context.completeStep();
    }

    @Override
    public ModelNode getModelDescription(Locale locale) {
        return this.getDescriptionProvider().getModelDescription(locale);
    }

    private synchronized DescriptionProvider getDescriptionProvider() {
        if (this.descriptionProvider == null) {
            this.descriptionProvider = this.isIncludeRestartServers() ? new DefaultOperationDescriptionProvider(OPERATION_NAME, this.resourceDescriptionResolver, ADMIN_ONLY, RESTART_SERVERS) : new DefaultOperationDescriptionProvider(OPERATION_NAME, this.resourceDescriptionResolver, ADMIN_ONLY);
        }
        return this.descriptionProvider;
    }

    protected boolean isIncludeRestartServers() {
        return false;
    }

    protected void reloadInitiated(T runningModeControl, boolean adminOnly, boolean restartServers) {
    }

    protected void doReload(T runningModeControl, boolean adminOnly, boolean restartServers) {
        ((RunningModeControl)runningModeControl).setRunningMode(adminOnly ? RunningMode.ADMIN_ONLY : RunningMode.NORMAL);
    }
}

