/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.ControllerMessages;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public class ExpressionResolverImpl
implements ExpressionResolver {
    protected ExpressionResolverImpl() {
    }

    @Override
    public final ModelNode resolveExpressions(ModelNode node) throws OperationFailedException {
        ModelNode resolved = this.resolveExpressionsRecursively(node);
        try {
            return resolved.resolve();
        }
        catch (SecurityException e) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.noPermissionToResolveExpression(resolved, e)));
        }
        catch (IllegalStateException e) {
            throw new OperationFailedException(new ModelNode().set(ControllerMessages.MESSAGES.cannotResolveExpression(resolved, e)));
        }
    }

    private ModelNode resolveExpressionsRecursively(ModelNode node) {
        ModelNode resolved;
        if (!node.isDefined()) {
            return node;
        }
        if (node.getType() == ModelType.EXPRESSION) {
            resolved = node.clone();
            this.resolvePluggableExpression(resolved);
        } else if (node.getType() == ModelType.OBJECT) {
            resolved = node.clone();
            for (Property prop : resolved.asPropertyList()) {
                resolved.get(prop.getName()).set(this.resolveExpressionsRecursively(prop.getValue()));
            }
        } else if (node.getType() == ModelType.LIST) {
            resolved = node.clone();
            ModelNode list = new ModelNode();
            for (ModelNode current : resolved.asList()) {
                list.add(this.resolveExpressionsRecursively(current));
            }
            resolved = list;
        } else if (node.getType() == ModelType.PROPERTY) {
            resolved = node.clone();
            resolved.set(resolved.asProperty().getName(), this.resolveExpressionsRecursively(resolved.asProperty().getValue()));
        } else {
            resolved = node;
        }
        return resolved;
    }

    protected void resolvePluggableExpression(ModelNode node) {
    }
}

