/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;

public abstract class AbstractRuntimeOnlyHandler
implements OperationStepHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor(ServiceController<?> controller) throws OperationFailedException {
        ServiceWaitListener listener = null;
        int time = 100;
        while (time > 0) {
            if (controller.getState() == ServiceController.State.UP) {
                return;
            }
            if (listener == null) {
                listener = new ServiceWaitListener();
                controller.addListener(listener);
            }
            ServiceWaitListener serviceWaitListener = listener;
            synchronized (serviceWaitListener) {
                try {
                    long start = System.currentTimeMillis();
                    listener.wait(time);
                    time = (int)((long)time - (System.currentTimeMillis() - start));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    controller.removeListener(listener);
                    throw new OperationFailedException(new ModelNode().set("Interrupted waiting for service: " + controller.getName()));
                }
            }
        }
        controller.removeListener(listener);
        if (controller.getState() != ServiceController.State.UP) {
            throw new OperationFailedException(new ModelNode().set("Required service is not available: " + controller.getName()));
        }
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        context.addStep(new OperationStepHandler(){

            @Override
            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                AbstractRuntimeOnlyHandler.this.executeRuntimeStep(context, operation);
            }
        }, OperationContext.Stage.RUNTIME);
        context.stepCompleted();
    }

    protected abstract void executeRuntimeStep(OperationContext var1, ModelNode var2) throws OperationFailedException;

    private static class ServiceWaitListener<T>
    implements ServiceListener<T> {
        private ServiceWaitListener() {
        }

        public void listenerAdded(ServiceController<? extends T> serviceController) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void transition(ServiceController<? extends T> serviceController, ServiceController.Transition transition) {
            if (transition.getAfter() == ServiceController.Substate.UP) {
                ServiceWaitListener serviceWaitListener = this;
                synchronized (serviceWaitListener) {
                    this.notify();
                }
            }
        }

        public void serviceRemoveRequested(ServiceController<? extends T> serviceController) {
        }

        public void serviceRemoveRequestCleared(ServiceController<? extends T> serviceController) {
        }

        public void dependencyFailed(ServiceController<? extends T> serviceController) {
        }

        public void dependencyFailureCleared(ServiceController<? extends T> serviceController) {
        }

        public void immediateDependencyUnavailable(ServiceController<? extends T> serviceController) {
        }

        public void immediateDependencyAvailable(ServiceController<? extends T> serviceController) {
        }

        public void transitiveDependencyUnavailable(ServiceController<? extends T> serviceController) {
        }

        public void transitiveDependencyAvailable(ServiceController<? extends T> serviceController) {
        }
    }
}

