/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.services.path;

import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ReadResourceNameOperationStepHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.services.path.PathAddHandler;
import org.jboss.as.controller.services.path.PathManagerService;
import org.jboss.as.controller.services.path.PathRemoveHandler;
import org.jboss.as.controller.services.path.PathWriteAttributeHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public abstract class PathResourceDefinition
extends SimpleResourceDefinition {
    private static final String SPECIFIED_PATH_RESOURCE_PREFIX = "specified_path";
    private static final String NAMED_PATH_RESOURCE_PREFIX = "named_path";
    public static final PathElement PATH_ADDRESS = PathElement.pathElement("path");
    static final SimpleAttributeDefinition NAME = ((SimpleAttributeDefinitionBuilder)SimpleAttributeDefinitionBuilder.create("name", ModelType.STRING, false).setValidator(new StringLengthValidator(1, false)).setResourceOnly()).build();
    static final SimpleAttributeDefinition PATH_SPECIFIED = SimpleAttributeDefinitionBuilder.create("path", ModelType.STRING, false).setAllowExpression(true).setValidator(new StringLengthValidator(1, false)).build();
    static final SimpleAttributeDefinition PATH_NAMED = SimpleAttributeDefinitionBuilder.create("path", ModelType.STRING, true).setAllowExpression(true).setValidator(new StringLengthValidator(1, true)).build();
    static final SimpleAttributeDefinition READ_ONLY = SimpleAttributeDefinitionBuilder.create("read-only", ModelType.BOOLEAN, true).setDefaultValue(new ModelNode(false)).setStorageRuntime().build();
    public static final SimpleAttributeDefinition PATH = SimpleAttributeDefinitionBuilder.create(PATH_SPECIFIED).build();
    public static final SimpleAttributeDefinition RELATIVE_TO = SimpleAttributeDefinitionBuilder.create("relative-to", ModelType.STRING, true).setValidator(new StringLengthValidator(1, true)).build();
    protected final PathManagerService pathManager;
    private final boolean specified;
    private final boolean services;

    private PathResourceDefinition(PathManagerService pathManager, ResourceDescriptionResolver resolver, PathAddHandler addHandler, PathRemoveHandler removeHandler, boolean specified, boolean services) {
        super(PATH_ADDRESS, resolver, addHandler, removeHandler);
        this.pathManager = pathManager;
        this.specified = specified;
        this.services = services;
    }

    public static PathResourceDefinition createSpecified(PathManagerService pathManager) {
        return new SpecifiedPathResourceDefinition(pathManager);
    }

    public static PathResourceDefinition createNamed(PathManagerService pathManager) {
        return new NamedPathResourceDefinition(pathManager);
    }

    public static PathResourceDefinition createSpecifiedNoServices(PathManagerService pathManager) {
        return new SpecifiedNoServicesPathResourceDefinition(pathManager);
    }

    @Override
    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadOnlyAttribute(NAME, ReadResourceNameOperationStepHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute(RELATIVE_TO, null, new PathWriteAttributeHandler(this.pathManager, RELATIVE_TO, this.services));
        SimpleAttributeDefinition pathAttr = this.specified ? PATH_SPECIFIED : PATH_NAMED;
        resourceRegistration.registerReadWriteAttribute(pathAttr, null, new PathWriteAttributeHandler(this.pathManager, pathAttr, this.services));
        resourceRegistration.registerReadOnlyAttribute(READ_ONLY, null);
    }

    private static class SpecifiedNoServicesPathResourceDefinition
    extends PathResourceDefinition {
        SpecifiedNoServicesPathResourceDefinition(PathManagerService pathManager) {
            super(pathManager, ControllerResolver.getResolver(PathResourceDefinition.SPECIFIED_PATH_RESOURCE_PREFIX), PathAddHandler.createSpecifiedNoServicesInstance(pathManager), PathRemoveHandler.createSpecifiedNoServicesInstance(pathManager), true, false);
        }
    }

    private static class NamedPathResourceDefinition
    extends PathResourceDefinition {
        NamedPathResourceDefinition(PathManagerService pathManager) {
            super(pathManager, ControllerResolver.getResolver(PathResourceDefinition.NAMED_PATH_RESOURCE_PREFIX), PathAddHandler.createNamedInstance(pathManager), PathRemoveHandler.createNamedInstance(pathManager), false, false);
        }
    }

    private static class SpecifiedPathResourceDefinition
    extends PathResourceDefinition {
        SpecifiedPathResourceDefinition(PathManagerService pathManager) {
            super(pathManager, ControllerResolver.getResolver(PathResourceDefinition.SPECIFIED_PATH_RESOURCE_PREFIX), PathAddHandler.createSpecifiedInstance(pathManager), PathRemoveHandler.createSpecifiedInstance(pathManager), true, true);
        }
    }
}

