/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.impl;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import org.jboss.as.server.deployment.api.ServerDeploymentRepository;
import org.jboss.as.server.deployment.impl.ContentRepositoryImpl;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossThreadFactory;
import org.jboss.vfs.TempFileProvider;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VFSUtils;
import org.jboss.vfs.VirtualFile;

public class ServerDeploymentRepositoryImpl
implements ServerDeploymentRepository,
Service<ServerDeploymentRepository> {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.server.deployment");
    private static final String EXTERNAL = "external";
    private final File systemDeployDir;
    private TempFileProvider tempFileProvider;
    private final ContentRepositoryImpl contentRepository;

    public static void addService(ServiceTarget serviceTarget, File repoRoot, File systemDeployDir, ContentRepositoryImpl contentRepository) {
        serviceTarget.addService(ServerDeploymentRepository.SERVICE_NAME, (Service)new ServerDeploymentRepositoryImpl(repoRoot, systemDeployDir, contentRepository)).install();
    }

    public ServerDeploymentRepositoryImpl(File repoRoot, File systemDeployDir, ContentRepositoryImpl contentRepository) {
        this.systemDeployDir = systemDeployDir;
        this.contentRepository = contentRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] addExternalFileReference(File file) throws IOException {
        OutputStream os;
        MessageDigest messageDigest;
        byte[] sha1Bytes = null;
        String fileName = file.getAbsolutePath();
        MessageDigest messageDigest2 = messageDigest = this.contentRepository.messageDigest;
        synchronized (messageDigest2) {
            messageDigest.reset();
            if (!file.exists()) {
                throw new FileNotFoundException(fileName);
            }
            os = new OutputStream(){

                @Override
                public void write(int b) throws IOException {
                }
            };
            DigestOutputStream dos = new DigestOutputStream(os, messageDigest);
            this.calculateHash(file, dos);
            sha1Bytes = messageDigest.digest();
        }
        File content = this.getExternalFileReference(sha1Bytes, true);
        os = new FileOutputStream(content);
        try {
            os.write(fileName.getBytes());
            os.flush();
            os.close();
        }
        finally {
            ContentRepositoryImpl.safeClose(os);
        }
        return sha1Bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void calculateHash(File file, OutputStream os) throws IOException {
        os.write(file.getAbsolutePath().getBytes());
        if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                this.calculateHash(f, os);
            }
        } else {
            FileInputStream is = new FileInputStream(file);
            try {
                VFSUtils.copyStreamAndClose((InputStream)is, (OutputStream)os);
            }
            finally {
                ContentRepositoryImpl.safeClose(is);
            }
        }
    }

    public boolean hasDeploymentContent(byte[] hash) {
        if (this.getExternalFileReference(hash, false).exists()) {
            return true;
        }
        return this.contentRepository.hasContent(hash);
    }

    private File getExternalFileReference(byte[] deploymentHash, boolean validate) {
        File hashDir = this.contentRepository.getDeploymentHashDir(deploymentHash, validate);
        return new File(hashDir, EXTERNAL);
    }

    @Override
    public Closeable mountDeploymentContent(String name, String runtimeName, VirtualFile contents, VirtualFile mountPoint) throws IOException {
        return this.mountDeploymentContent(name, runtimeName, contents, mountPoint, false);
    }

    @Override
    public Closeable mountDeploymentContent(String name, String runtimeName, VirtualFile contents, VirtualFile mountPoint, boolean mountExpanded) throws IOException {
        if (contents == null) {
            throw new IllegalArgumentException("contents is null");
        }
        if (mountExpanded) {
            return VFS.mountZipExpanded((VirtualFile)contents, (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
        }
        return VFS.mountZip((VirtualFile)contents, (VirtualFile)mountPoint, (TempFileProvider)this.tempFileProvider);
    }

    public void start(StartContext context) throws StartException {
        try {
            JBossThreadFactory threadFactory = new JBossThreadFactory(new ThreadGroup("ServerDeploymentRepository-temp-threads"), Boolean.FALSE, null, "%G - %t", null, null, AccessController.getContext());
            this.tempFileProvider = TempFileProvider.create((String)"temp", (ScheduledExecutorService)Executors.newScheduledThreadPool(2, (ThreadFactory)threadFactory));
        }
        catch (IOException e) {
            throw new StartException("Failed to create temp file provider");
        }
        log.debugf("%s started", (Object)ServerDeploymentRepository.class.getSimpleName());
    }

    public void stop(StopContext context) {
        log.debugf("%s stopped", (Object)ServerDeploymentRepository.class.getSimpleName());
    }

    public ServerDeploymentRepository getValue() throws IllegalStateException {
        return this;
    }
}

