/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment.scanner;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.server.deployment.scanner.DeploymentScannerService;
import org.jboss.as.server.deployment.scanner.api.DeploymentScanner;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;

abstract class AbstractWriteAttributeHandler
extends ServerWriteAttributeOperationHandler {
    AbstractWriteAttributeHandler(ParameterValidator valueValidator, ParameterValidator resolvedValueValidator) {
        super(valueValidator, resolvedValueValidator);
    }

    protected boolean applyUpdateToRuntime(OperationContext context, final ModelNode operation, final ResultHandler resultHandler, String attributeName, final ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
                    String name = address.getLastElement().getValue();
                    ServiceController controller = context.getServiceRegistry().getService(DeploymentScannerService.getServiceName(name));
                    if (controller == null) {
                        throw new OperationFailedException(new ModelNode().set("scanner not configured"));
                    }
                    DeploymentScanner scanner = (DeploymentScanner)controller.getValue();
                    AbstractWriteAttributeHandler.this.updateScanner(scanner, newValue);
                    resultHandler.handleResultComplete();
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        return false;
    }

    protected abstract void updateScanner(DeploymentScanner var1, ModelNode var2);
}

