/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.controller.plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.domain.controller.ServerIdentity;
import org.jboss.as.domain.controller.plan.AbstractServerUpdateTask;
import org.jboss.as.domain.controller.plan.ConcurrentGroupServerUpdatePolicy;
import org.jboss.as.domain.controller.plan.ConcurrentUpdateTask;
import org.jboss.as.domain.controller.plan.RollingUpdateTask;
import org.jboss.as.domain.controller.plan.RunningServerUpdateTask;
import org.jboss.as.domain.controller.plan.ServerOperationExecutor;
import org.jboss.as.domain.controller.plan.ServerRestartTask;
import org.jboss.as.domain.controller.plan.ServerUpdatePolicy;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class RolloutPlanController
implements AbstractServerUpdateTask.ServerUpdateResultHandler {
    private final ModelNode rolloutPlan;
    private final ResultHandler resultHandler;
    private final boolean rollbackAcrossGroups;
    private final ExecutorService executor;
    private final Runnable rootTask;
    private final Map<String, ServerUpdatePolicy> updatePolicies = new HashMap<String, ServerUpdatePolicy>();
    private final boolean shutdown;
    private final long gracefulShutdownPeriod;
    private final ServerOperationExecutor serverOperationExecutor;
    private final ConcurrentMap<String, Map<ServerIdentity, ModelNode>> serverResults = new ConcurrentHashMap<String, Map<ServerIdentity, ModelNode>>();
    private final boolean forRollback;

    public RolloutPlanController(Map<String, Map<ServerIdentity, ModelNode>> opsByGroup, ModelNode rolloutPlan, ResultHandler resultHandler, ServerOperationExecutor serverOperationExecutor, ExecutorService executor, boolean forRollback) {
        this.executor = executor;
        this.rolloutPlan = rolloutPlan;
        this.resultHandler = resultHandler;
        this.serverOperationExecutor = serverOperationExecutor;
        this.forRollback = forRollback;
        this.rollbackAcrossGroups = !rolloutPlan.hasDefined("rollback-across-groups") || rolloutPlan.get("rollback-across-groups").asBoolean();
        this.shutdown = rolloutPlan.hasDefined("shutdown") && rolloutPlan.get("shutdown").asBoolean();
        this.gracefulShutdownPeriod = rolloutPlan.hasDefined("graceful-shutdown-timeout") ? (long)rolloutPlan.get("graceful-shutdown-timeout").asInt() : -1L;
        ArrayList<Runnable> rollingTasks = new ArrayList<Runnable>();
        this.rootTask = new RollingUpdateTask(rollingTasks);
        if (rolloutPlan.hasDefined("in-series")) {
            ConcurrentGroupServerUpdatePolicy predecessor = null;
            for (ModelNode series : rolloutPlan.get("in-series").asList()) {
                ArrayList<Runnable> seriesTasks = new ArrayList<Runnable>();
                rollingTasks.add(new ConcurrentUpdateTask(seriesTasks, executor));
                HashSet<String> groupNames = new HashSet<String>();
                ArrayList<Property> groupPolicies = new ArrayList<Property>();
                if (series.hasDefined("concurrent-groups")) {
                    for (Property pol : series.get("concurrent-groups").asPropertyList()) {
                        groupNames.add(pol.getName());
                        groupPolicies.add(pol);
                    }
                } else {
                    Property pol = series.require("server-group").asProperty();
                    groupNames.add(pol.getName());
                    groupPolicies.add(pol);
                }
                ConcurrentGroupServerUpdatePolicy parent = new ConcurrentGroupServerUpdatePolicy(predecessor, groupNames);
                for (Property prop : groupPolicies) {
                    ServerUpdatePolicy policy;
                    String serverGroupName = prop.getName();
                    Map<ServerIdentity, ModelNode> groupEntry = opsByGroup.get(serverGroupName);
                    if (groupEntry == null) continue;
                    ArrayList<Runnable> groupTasks = new ArrayList<Runnable>();
                    ModelNode policyNode = prop.getValue();
                    boolean rollingGroup = policyNode.hasDefined("rolling-to-servers") && policyNode.get("rolling-to-servers").asBoolean();
                    seriesTasks.add(rollingGroup ? new RollingUpdateTask(groupTasks) : new ConcurrentUpdateTask(groupTasks, executor));
                    Set<ServerIdentity> servers = groupEntry.keySet();
                    if (forRollback) {
                        policy = new ServerUpdatePolicy(parent, serverGroupName, servers);
                    } else {
                        int maxFailures = 0;
                        if (policyNode.hasDefined("max-failure-percentage")) {
                            int pct = policyNode.get("max-failure-percentage").asInt();
                            maxFailures = servers.size() * pct / 100;
                        } else if (policyNode.hasDefined("max-failed-servers")) {
                            maxFailures = policyNode.get("max-failed-servers").asInt();
                        }
                        policy = new ServerUpdatePolicy(parent, serverGroupName, servers, maxFailures);
                    }
                    this.updatePolicies.put(serverGroupName, policy);
                    for (Map.Entry<ServerIdentity, ModelNode> entry : groupEntry.entrySet()) {
                        groupTasks.add(this.createServerTask(entry.getKey(), entry.getValue(), policy));
                    }
                }
            }
        }
    }

    public Result execute() {
        this.rootTask.run();
        Result result = null;
        for (ServerUpdatePolicy policy : this.updatePolicies.values()) {
            if (policy.isFailed()) {
                result = result == null || result == Result.FAILED ? Result.FAILED : Result.PARTIAL;
                continue;
            }
            result = result == null || result == Result.SUCCESS ? Result.SUCCESS : Result.PARTIAL;
        }
        return result;
    }

    public Result rollback() {
        if (this.forRollback) {
            throw new IllegalStateException("Cannot call rollback() on a controller that itself is managing a rollback");
        }
        RolloutPlanController rollbackController = this.createRollbackController();
        return rollbackController.execute();
    }

    @Override
    public void handleServerUpdateResult(ServerIdentity serverId, ModelNode response) {
        Map existing;
        String[] location = new String[]{"server-groups", serverId.getServerGroupName(), serverId.getServerName(), "host"};
        this.resultHandler.handleResultFragment(location, new ModelNode().set(serverId.getHostName()));
        location[3] = "response";
        this.resultHandler.handleResultFragment(location, response);
        Map<ServerIdentity, Object> groupResults = (ConcurrentHashMap<ServerIdentity, ModelNode>)this.serverResults.get(serverId.getServerGroupName());
        if (groupResults == null) {
            groupResults = new ConcurrentHashMap<ServerIdentity, ModelNode>();
        }
        if ((existing = (Map)this.serverResults.putIfAbsent(serverId.getServerGroupName(), groupResults)) != null) {
            groupResults = existing;
        }
        groupResults.put(serverId, response);
    }

    private Runnable createServerTask(ServerIdentity serverIdentity, ModelNode serverOp, ServerUpdatePolicy policy) {
        AbstractServerUpdateTask result = this.shutdown ? new ServerRestartTask(this.serverOperationExecutor, serverIdentity, policy, this, this.gracefulShutdownPeriod) : new RunningServerUpdateTask(this.serverOperationExecutor, serverIdentity, serverOp, policy, this);
        return result;
    }

    private RolloutPlanController createRollbackController() {
        HashMap<String, Map<ServerIdentity, ModelNode>> rollbackOpsByGroup = new HashMap<String, Map<ServerIdentity, ModelNode>>();
        for (Map.Entry<String, ServerUpdatePolicy> entry : this.updatePolicies.entrySet()) {
            if (!this.rollbackAcrossGroups && !entry.getValue().isFailed()) continue;
            Map groupResults = (Map)this.serverResults.get(entry.getKey());
            for (Map.Entry serverEntry : groupResults.entrySet()) {
                ModelNode serverResult = (ModelNode)serverEntry.getValue();
                if (!this.needsRollback(serverResult) || !serverResult.hasDefined("compensating-operation")) continue;
                String groupName = ((ServerIdentity)serverEntry.getKey()).getServerGroupName();
                HashMap groupRollbacks = (HashMap)rollbackOpsByGroup.get(groupName);
                if (groupRollbacks == null) {
                    groupRollbacks = new HashMap();
                    rollbackOpsByGroup.put(groupName, groupRollbacks);
                }
                groupRollbacks.put(serverEntry.getKey(), serverResult.get("compensating-operation"));
            }
        }
        ModelNode rollbackRolloutPlan = new ModelNode();
        rollbackRolloutPlan.get("rollback-across-groups").set(false);
        for (ModelNode series : this.rolloutPlan.get("in-series").asList()) {
            if (series.hasDefined("concurrent-groups")) {
                ModelNode item = null;
                for (Property prop : series.get("concurrent-groups").asPropertyList()) {
                    if (!rollbackOpsByGroup.containsKey(prop.getName())) continue;
                    ModelNode rollbackPolicy = this.getRollbackPolicy(prop.getValue());
                    if (item == null) {
                        item = new ModelNode();
                    }
                    item.get(prop.getName()).set(rollbackPolicy);
                }
                if (item == null) continue;
                rollbackRolloutPlan.get("in-series").add().get("concurrent-groups").set(item);
                continue;
            }
            Property prop = series.get("server-group").asProperty();
            if (!rollbackOpsByGroup.containsKey(prop.getName())) continue;
            ModelNode rollbackPolicy = this.getRollbackPolicy(prop.getValue());
            rollbackRolloutPlan.get("in-series").add().get(new String[]{"server-group", prop.getName()}).set(rollbackPolicy);
        }
        return new RolloutPlanController(rollbackOpsByGroup, rollbackRolloutPlan, this.resultHandler, this.serverOperationExecutor, this.executor, true);
    }

    private boolean needsRollback(ModelNode serverResult) {
        String outcome = serverResult.require("outcome").asString();
        if ("cancelled".equals(outcome)) {
            return false;
        }
        return !serverResult.hasDefined("rolled-back") || !serverResult.get("rolled-back").asBoolean();
    }

    private ModelNode getRollbackPolicy(ModelNode preRollback) {
        ModelNode result = new ModelNode();
        if (preRollback.hasDefined("rolling-to-servers")) {
            result.get("rolling-to-servers").set(preRollback.get("rolling-to-servers"));
        }
        result.get("max-failure-percentage").set(100);
        return result;
    }

    public static enum Result {
        SUCCESS,
        PARTIAL,
        FAILED;

    }
}

