/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.IOException;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.Filter;
import org.jboss.com.sun.net.httpserver.Headers;
import org.jboss.com.sun.net.httpserver.HttpExchange;

class RealmReadinessFilter
extends Filter {
    private final SecurityRealm securityRealm;
    private final String redirectTo;

    RealmReadinessFilter(SecurityRealm securityRealm, String redirectTo) {
        this.securityRealm = securityRealm;
        this.redirectTo = redirectTo;
    }

    public void doFilter(HttpExchange exchange, Filter.Chain chain) throws IOException {
        if (this.securityRealm.isReady()) {
            chain.doFilter(exchange);
        } else {
            Headers responseHeaders = exchange.getResponseHeaders();
            responseHeaders.add("Location", this.redirectTo);
            exchange.sendResponseHeaders(307, 0L);
            exchange.close();
        }
    }

    public String description() {
        return HttpServerMessages.MESSAGES.realmReadinessFilter();
    }
}

