/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.http.server;

import java.io.File;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.jboss.as.domain.http.server.ConsoleVersion;
import org.jboss.as.domain.http.server.ErrorHandler;
import org.jboss.as.domain.http.server.HttpServerMessages;
import org.jboss.as.domain.http.server.RedirectReadinessFilter;
import org.jboss.as.domain.http.server.ResourceHandler;
import org.jboss.as.domain.http.server.SecurityActions;
import org.jboss.as.domain.management.AuthenticationMechanism;
import org.jboss.as.domain.management.SecurityRealm;
import org.jboss.com.sun.net.httpserver.HttpContext;
import org.jboss.com.sun.net.httpserver.HttpHandler;
import org.jboss.com.sun.net.httpserver.HttpServer;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;

public enum ConsoleMode {
    CONSOLE{

        @Override
        ResourceHandler createConsoleHandler(String skin) throws ModuleLoadException {
            return new ConsoleHandler(skin);
        }

        @Override
        public boolean hasConsole() {
            return true;
        }
    }
    ,
    SLAVE_HC{

        @Override
        ResourceHandler createConsoleHandler(String skin) throws ModuleLoadException {
            return DisabledConsoleHandler.createNoConsoleForSlave(skin);
        }

        @Override
        public boolean hasConsole() {
            return false;
        }
    }
    ,
    ADMIN_ONLY{

        @Override
        ResourceHandler createConsoleHandler(String skin) throws ModuleLoadException {
            return DisabledConsoleHandler.createNoConsoleForAdminMode(skin);
        }

        @Override
        public boolean hasConsole() {
            return false;
        }
    }
    ,
    NO_CONSOLE{

        @Override
        ResourceHandler createConsoleHandler(String skin) throws ModuleLoadException {
            return null;
        }

        @Override
        public boolean hasConsole() {
            return false;
        }
    };


    ResourceHandler createConsoleHandler(String skin) throws ModuleLoadException {
        throw new IllegalStateException("Not overridden for " + (Object)((Object)this));
    }

    public boolean hasConsole() {
        throw new IllegalStateException("Not overridden for " + (Object)((Object)this));
    }

    static SortedSet<ConsoleVersion> findConsoleVersions(String moduleName) {
        String path = moduleName.replace('.', '/');
        String modulePath = SecurityActions.getProperty("module.path");
        File[] moduleRoots = ConsoleMode.getFiles(modulePath, 0, 0);
        TreeSet<ConsoleVersion> consoleVersions = new TreeSet<ConsoleVersion>();
        for (File root : moduleRoots) {
            File addOns;
            ConsoleMode.findConsoleModules(root, path, consoleVersions);
            File layers = new File(root, "system" + File.separator + "layers");
            File[] children = layers.listFiles();
            if (children != null) {
                for (File child : children) {
                    ConsoleMode.findConsoleModules(child, path, consoleVersions);
                }
            }
            if ((children = (addOns = new File(root, "system" + File.separator + "add-ons")).listFiles()) == null) continue;
            for (File child : children) {
                ConsoleMode.findConsoleModules(child, path, consoleVersions);
            }
        }
        return consoleVersions;
    }

    private static void findConsoleModules(File root, String path, Set<ConsoleVersion> consoleVersions) {
        File module = new File(root, path);
        File[] children = module.listFiles();
        if (children != null) {
            for (File child : children) {
                consoleVersions.add(new ConsoleVersion(child.getName()));
            }
        }
    }

    private static File[] getFiles(String modulePath, int stringIdx, int arrayIdx) {
        File[] files;
        int i = modulePath.indexOf(File.pathSeparatorChar, stringIdx);
        if (i == -1) {
            files = new File[arrayIdx + 1];
            files[arrayIdx] = new File(modulePath.substring(stringIdx)).getAbsoluteFile();
        } else {
            files = ConsoleMode.getFiles(modulePath, i + 1, arrayIdx + 1);
            files[arrayIdx] = new File(modulePath.substring(stringIdx, i)).getAbsoluteFile();
        }
        return files;
    }

    static class DisabledConsoleHandler
    extends ResourceHandler {
        private static final String ERROR_MODULE = "org.jboss.as.domain-http-error-context";
        private static final String CONTEXT = "/consoleerror";
        private static final String NO_CONSOLE_FOR_SLAVE = "/noConsoleForSlaveDcError.html";
        private static final String NO_CONSOLE_FOR_ADMIN_MODE = "/noConsoleForAdminModeError.html";

        private DisabledConsoleHandler(String slot, String resource) throws ModuleLoadException {
            super(CONTEXT, resource, DisabledConsoleHandler.getClassLoader(Module.getCallerModuleLoader(), ERROR_MODULE, slot));
        }

        static DisabledConsoleHandler createNoConsoleForSlave(String slot) throws ModuleLoadException {
            return new DisabledConsoleHandler(slot, NO_CONSOLE_FOR_SLAVE);
        }

        static DisabledConsoleHandler createNoConsoleForAdminMode(String slot) throws ModuleLoadException {
            return new DisabledConsoleHandler(slot, NO_CONSOLE_FOR_ADMIN_MODE);
        }

        @Override
        protected boolean skipCache(String resource) {
            return true;
        }
    }

    static class ConsoleHandler
    extends ResourceHandler {
        private static final String NOCACHE_JS = ".nocache.js";
        private static final String INDEX_HTML = "index.html";
        private static final String APP_HTML = "App.html";
        private static final String CONSOLE_MODULE = "org.jboss.as.console";
        private static final String CONTEXT = "/console";
        private static final String DEFAULT_RESOURCE = "/index.html";

        ConsoleHandler(String skin) throws ModuleLoadException {
            super(CONTEXT, DEFAULT_RESOURCE, ConsoleHandler.findConsoleClassLoader(Module.getCallerModuleLoader(), skin));
        }

        @Override
        protected boolean skipCache(String resource) {
            return resource.endsWith(NOCACHE_JS) || resource.endsWith(APP_HTML) || resource.endsWith(INDEX_HTML);
        }

        @Override
        public void start(HttpServer httpServer, SecurityRealm securityRealm) {
            HttpContext httpContext = httpServer.createContext(this.getContext(), (HttpHandler)this);
            if (securityRealm != null && !securityRealm.getSupportedAuthenticationMechanisms().contains(AuthenticationMechanism.CLIENT_CERT)) {
                httpContext.getFilters().add(new RedirectReadinessFilter(securityRealm, ErrorHandler.getRealmRedirect()));
            }
        }

        static ClassLoader findConsoleClassLoader(ModuleLoader moduleLoader, String consoleSkin) throws ModuleLoadException {
            String moduleName = "org.jboss.as.console." + (consoleSkin == null ? "main" : consoleSkin);
            SortedSet<ConsoleVersion> consoleVersions = ConsoleMode.findConsoleVersions(moduleName);
            for (ConsoleVersion consoleVersion : consoleVersions) {
                try {
                    return ConsoleHandler.getClassLoader(moduleLoader, moduleName, consoleVersion.getName());
                }
                catch (ModuleLoadException mle) {
                }
            }
            try {
                return ConsoleHandler.getClassLoader(moduleLoader, CONSOLE_MODULE, consoleSkin);
            }
            catch (ModuleLoadException mle) {
                throw HttpServerMessages.MESSAGES.consoleModuleNotFound(moduleName);
            }
        }
    }
}

