/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.operations;

import java.util.Locale;
import org.jboss.as.controller.BasicOperationResult;
import org.jboss.as.controller.ModelAddOperationHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationResult;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ResultHandler;
import org.jboss.as.controller.RuntimeTask;
import org.jboss.as.controller.RuntimeTaskContext;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.domain.management.security.LdapConnectionManagerService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;

public class ConnectionAddHandler
implements ModelAddOperationHandler,
DescriptionProvider {
    public static final ConnectionAddHandler INSTANCE = new ConnectionAddHandler();
    public static final String OPERATION_NAME = "add";

    public OperationResult execute(OperationContext context, ModelNode operation, ResultHandler resultHandler) throws OperationFailedException {
        ModelNode operationAddress = operation.require("address");
        PathAddress address = PathAddress.pathAddress((ModelNode)operationAddress);
        final String name = address.getLastElement().getValue();
        final String type = operation.get("type").asString();
        final ModelNode subModel = context.getSubModel();
        subModel.get("type").set(operation.require("type").asString());
        subModel.get("url").set(operation.require("url").asString());
        subModel.get("search-dn").set(operation.require("search-dn").asString());
        subModel.get("search-credential").set(operation.require("search-credential").asString());
        if (operation.has("initial-context-factory")) {
            subModel.get("initial-context-factory").set(operation.require("initial-context-factory").asString());
        }
        if (context.getRuntimeContext() != null) {
            context.getRuntimeContext().setRuntimeTask(new RuntimeTask(){

                public void execute(RuntimeTaskContext context) throws OperationFailedException {
                    ServiceTarget serviceTarget = context.getServiceTarget();
                    if ("ldap".equals(type)) {
                        LdapConnectionManagerService connectionManagerService = new LdapConnectionManagerService(subModel);
                        serviceTarget.addService(LdapConnectionManagerService.BASE_SERVICE_NAME.append(new String[]{name}), (Service)connectionManagerService).setInitialMode(ServiceController.Mode.ON_DEMAND).install();
                    }
                }
            });
        } else {
            resultHandler.handleResultComplete();
        }
        ModelNode compensatingOperation = new ModelNode();
        return new BasicOperationResult(compensatingOperation);
    }

    public ModelNode getModelDescription(Locale locale) {
        return new ModelNode();
    }
}

