/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.LinkedList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.dmr.ModelNode;

public class UserDomainCallbackHandler
implements DomainCallbackHandler {
    private static final Class[] supportedCallbacks = new Class[]{RealmCallback.class, NameCallback.class, PasswordCallback.class};
    private final String realm;
    private final ModelNode userDomain;

    UserDomainCallbackHandler(String realm, ModelNode userDomain) {
        this.realm = realm;
        this.userDomain = userDomain;
    }

    @Override
    public Class[] getSupportedCallbacks() {
        return supportedCallbacks;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        ModelNode user = null;
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                user = this.userDomain.get(new String[]{"user", userName});
                continue;
            }
            if (current instanceof PasswordCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw new IllegalStateException("Invalid Realm '" + realm + "' expected '" + this.realm + "'");
            }
            throw new UnsupportedCallbackException(current);
        }
        if (user == null) {
            throw new IllegalStateException("User '" + userName + "' not found.");
        }
        for (Callback current : toRespondTo) {
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizedID()));
                continue;
            }
            if (!(current instanceof PasswordCallback)) continue;
            String password = user.require("password").asString();
            ((PasswordCallback)current).setPassword(password.toCharArray());
        }
    }
}

