/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.IOException;
import java.util.LinkedList;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.AuthorizeCallback;
import javax.security.sasl.RealmCallback;
import org.jboss.as.domain.management.security.DomainCallbackHandler;
import org.jboss.as.domain.management.security.UserNotFoundException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;

public class UserDomainCallbackHandler
implements Service<UserDomainCallbackHandler>,
DomainCallbackHandler {
    public static final String SERVICE_SUFFIX = "users";
    private static final Class[] supportedCallbacks = new Class[]{AuthorizeCallback.class, RealmCallback.class, NameCallback.class, PasswordCallback.class};
    private final String realm;
    private final ModelNode userDomain;

    public UserDomainCallbackHandler(String realm, ModelNode userDomain) {
        this.realm = realm;
        this.userDomain = userDomain;
    }

    public void start(StartContext context) throws StartException {
    }

    public void stop(StopContext context) {
    }

    public UserDomainCallbackHandler getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    @Override
    public Class[] getSupportedCallbacks() {
        return supportedCallbacks;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        LinkedList<Callback> toRespondTo = new LinkedList<Callback>();
        String userName = null;
        ModelNode user = null;
        for (Callback current : callbacks) {
            if (current instanceof AuthorizeCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof NameCallback) {
                NameCallback nameCallback = (NameCallback)current;
                userName = nameCallback.getDefaultName();
                if (!this.userDomain.get("user").hasDefined(userName)) continue;
                user = this.userDomain.get(new String[]{"user", userName});
                continue;
            }
            if (current instanceof PasswordCallback) {
                toRespondTo.add(current);
                continue;
            }
            if (current instanceof RealmCallback) {
                String realm = ((RealmCallback)current).getDefaultText();
                if (this.realm.equals(realm)) continue;
                throw new IllegalStateException("Invalid Realm '" + realm + "' expected '" + this.realm + "'");
            }
            throw new UnsupportedCallbackException(current);
        }
        for (Callback current : toRespondTo) {
            if (current instanceof AuthorizeCallback) {
                AuthorizeCallback authorizeCallback = (AuthorizeCallback)current;
                authorizeCallback.setAuthorized(authorizeCallback.getAuthenticationID().equals(authorizeCallback.getAuthorizationID()));
                continue;
            }
            if (!(current instanceof PasswordCallback)) continue;
            if (user == null) {
                throw new UserNotFoundException(userName);
            }
            String password = user.require("password").asString();
            ((PasswordCallback)current).setPassword(password.toCharArray());
        }
    }
}

