/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import java.io.Closeable;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.Properties;
import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.JavaConsole;
import org.jboss.as.domain.management.security.state.PropertyFileFinder;
import org.jboss.as.domain.management.security.state.PropertyFilePrompt;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class AddPropertiesUser {
    public static final String[] BAD_USER_NAMES = new String[]{"admin", "administrator", "root"};
    public static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    public static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    public static final String SERVER_CONFIG_USER_DIR = "jboss.server.config.user.dir";
    public static final String DOMAIN_BASE_DIR = "jboss.domain.base.dir";
    public static final String DOMAIN_CONFIG_DIR = "jboss.domain.config.dir";
    public static final String DOMAIN_CONFIG_USER_DIR = "jboss.domain.config.user.dir";
    public static final String DEFAULT_MANAGEMENT_REALM = "ManagementRealm";
    public static final String DEFAULT_APPLICATION_REALM = "ApplicationRealm";
    public static final String MGMT_USERS_PROPERTIES = "mgmt-users.properties";
    public static final String APPLICATION_USERS_PROPERTIES = "application-users.properties";
    public static final String APPLICATION_ROLES_PROPERTIES = "application-roles.properties";
    public static final String APPLICATION_USERS_SWITCH = "-a";
    public static final String DOMAIN_CONFIG_DIR_USERS_SWITCH = "-dc";
    public static final String SERVER_CONFIG_DIR_USERS_SWITCH = "-sc";
    public static final String NEW_LINE = "\n";
    public static final String SPACE = " ";
    private static final Properties argsCliProps = new Properties();
    private final ConsoleWrapper theConsole;
    protected State nextState;

    protected AddPropertiesUser() {
        this.theConsole = new JavaConsole();
        StateValues stateValues = new StateValues();
        stateValues.setJbossHome(System.getenv("JBOSS_HOME"));
        if (this.theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
        this.nextState = new PropertyFilePrompt(this.theConsole, stateValues);
    }

    protected AddPropertiesUser(ConsoleWrapper console) {
        this.theConsole = console;
        StateValues stateValues = new StateValues();
        stateValues.setJbossHome(System.getenv("JBOSS_HOME"));
        this.nextState = new PropertyFilePrompt(this.theConsole, stateValues);
    }

    private AddPropertiesUser(boolean management, String user, char[] password, String realm) {
        boolean silent = false;
        StateValues stateValues = new StateValues();
        stateValues.setJbossHome(System.getenv("JBOSS_HOME"));
        String valueSilent = argsCliProps.getProperty("silent");
        if (valueSilent != null) {
            silent = Boolean.valueOf(valueSilent);
        }
        if (silent) {
            stateValues.setHowInteractive(Interactiveness.SILENT);
        } else {
            stateValues.setHowInteractive(Interactiveness.NON_INTERACTIVE);
        }
        this.theConsole = new JavaConsole();
        if (this.theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
        stateValues.setUserName(user);
        stateValues.setPassword(password);
        stateValues.setRealm(realm);
        stateValues.setManagement(management);
        this.nextState = new PropertyFileFinder(this.theConsole, stateValues);
    }

    private AddPropertiesUser(boolean management, String user, char[] password) {
        this(management, user, password, management ? DEFAULT_MANAGEMENT_REALM : DEFAULT_APPLICATION_REALM);
    }

    protected void run() {
        while ((this.nextState = this.nextState.execute()) != null) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int realArgsLength;
        LinkedList<String> argsList = new LinkedList<String>();
        String[] argsArray = null;
        StringReader stringReader = null;
        boolean management = true;
        if (args.length >= 1) {
            for (String temp : args) {
                if (temp.startsWith("--")) {
                    try {
                        stringReader = new StringReader(temp.substring(2));
                        argsCliProps.load(stringReader);
                    }
                    catch (IOException e) {
                        try {
                            e.printStackTrace();
                        }
                        catch (Throwable throwable) {
                            AddPropertiesUser.safeClose(stringReader);
                            throw throwable;
                        }
                        AddPropertiesUser.safeClose(stringReader);
                        continue;
                    }
                    AddPropertiesUser.safeClose(stringReader);
                    continue;
                }
                if (temp.equals(APPLICATION_USERS_SWITCH)) {
                    management = false;
                    continue;
                }
                if (temp.indexOf(DOMAIN_CONFIG_DIR_USERS_SWITCH) >= 0) {
                    System.setProperty(DOMAIN_CONFIG_DIR, temp.substring(3));
                    continue;
                }
                if (temp.indexOf(SERVER_CONFIG_DIR) >= 0) {
                    System.setProperty(SERVER_CONFIG_DIR, temp.substring(3));
                    continue;
                }
                argsList.add(temp);
            }
        }
        if ((realArgsLength = (argsArray = argsList.toArray(new String[0])).length) == 3) {
            new AddPropertiesUser(management, argsArray[0], argsArray[1].toCharArray(), argsArray[2]).run();
        } else if (realArgsLength == 2) {
            new AddPropertiesUser(management, argsArray[0], argsArray[1].toCharArray()).run();
        } else {
            new AddPropertiesUser().run();
        }
    }

    private static void safeClose(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static enum Interactiveness {
        SILENT,
        NON_INTERACTIVE,
        INTERACTIVE;

    }
}

