/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.RestartParentWriteAttributeHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.domain.management.security.ManagementUtil;
import org.jboss.as.domain.management.security.SecurityRealmAddHandler;
import org.jboss.as.domain.management.security.SecurityRealmRemoveHandler;
import org.jboss.as.domain.management.security.SecurityRealmService;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;

public class SecurityRealmChildWriteAttributeHandler
extends RestartParentWriteAttributeHandler {
    private final AttributeDefinition[] attributeDefinitions;

    public SecurityRealmChildWriteAttributeHandler(AttributeDefinition ... attributes) {
        super("security-realm", attributes);
        this.attributeDefinitions = attributes;
    }

    void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        for (AttributeDefinition attr : this.attributeDefinitions) {
            resourceRegistration.registerReadWriteAttribute(attr, null, (OperationStepHandler)this);
        }
    }

    protected boolean requiresRuntime(OperationContext context) {
        return true;
    }

    protected boolean isResourceServiceRestartAllowed(OperationContext context, ServiceController<?> service) {
        return !ManagementUtil.isSecurityRealmReloadRequired(context, service);
    }

    protected void removeServices(OperationContext context, ServiceName parentService, ModelNode parentModel) throws OperationFailedException {
        SecurityRealmRemoveHandler.INSTANCE.removeServices(context, parentService.getSimpleName(), parentModel);
    }

    protected void recreateParentService(OperationContext context, PathAddress parentAddress, ModelNode parentModel, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        SecurityRealmAddHandler.INSTANCE.installServices(context, parentAddress.getLastElement().getValue(), parentModel, verificationHandler, null);
    }

    protected ServiceName getParentServiceName(PathAddress parentAddress) {
        String realmName = parentAddress.getLastElement().getValue();
        return SecurityRealmService.BASE_SERVICE_NAME.append(new String[]{realmName});
    }
}

