/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security.state;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.ConsoleWrapper;
import org.jboss.as.domain.management.security.state.State;
import org.jboss.as.domain.management.security.state.StateValues;

public class ErrorState
implements State {
    private final State nextState;
    private final String errorMessage;
    private final StateValues stateValues;
    private ConsoleWrapper theConsole;

    public ErrorState(ConsoleWrapper theConsole, String errorMessage) {
        this(theConsole, errorMessage, null, null);
    }

    public ErrorState(ConsoleWrapper theConsole, String errorMessage, State nextState) {
        this(theConsole, errorMessage, nextState, null);
    }

    public ErrorState(ConsoleWrapper theConsole, String errorMessage, State nextState, StateValues stateValues) {
        this.errorMessage = errorMessage;
        this.nextState = nextState;
        this.stateValues = stateValues;
        this.theConsole = theConsole;
        if (stateValues != null && !stateValues.isSilent() && theConsole.getConsole() == null) {
            throw DomainManagementMessages.MESSAGES.noConsoleAvailable();
        }
    }

    @Override
    public State execute() {
        this.theConsole.printf("\n", new Object[0]);
        this.theConsole.printf(" * ", new Object[0]);
        this.theConsole.printf(DomainManagementMessages.MESSAGES.errorHeader(), new Object[0]);
        this.theConsole.printf(" * ", new Object[0]);
        this.theConsole.printf("\n", new Object[0]);
        this.theConsole.printf(this.errorMessage, new Object[0]);
        this.theConsole.printf("\n", new Object[0]);
        this.theConsole.printf("\n", new Object[0]);
        return this.nextState;
    }
}

