/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.domain.management.security;

import org.jboss.as.domain.management.DomainManagementMessages;
import org.jboss.as.domain.management.security.DomainManagementPrincipal;

public class RealmUser
extends DomainManagementPrincipal {
    private final String realm;

    public RealmUser(String name) {
        super(name);
        this.realm = null;
    }

    public RealmUser(String realm, String name) {
        super(name);
        if (name == null) {
            throw DomainManagementMessages.MESSAGES.canNotBeNull("realm");
        }
        this.realm = realm;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getFullName() {
        return this.realm == null ? this.getName() : this.getName() + "@" + this.realm;
    }

    @Override
    public String toString() {
        return this.getFullName();
    }

    @Override
    public int hashCode() {
        return (super.hashCode() + 31) * (this.realm == null ? 101 : this.realm.hashCode());
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RealmUser ? this.equals((RealmUser)obj) : false;
    }

    private boolean equals(RealmUser user) {
        return this == user ? true : super.equals(user) && this.realm.equals(user.realm);
    }
}

