/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2011, Red Hat, Inc., and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */

package org.jboss.as.ee.component;

import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

/**
 * @author <a href="mailto:david.lloyd@redhat.com">David M. Lloyd</a>
 */
public final class ViewBindingInjectionSource extends InjectionSource {

    private static final int HASH_BASE = ViewBindingInjectionSource.class.hashCode() * 127;

    private final ServiceName serviceName;

    public ViewBindingInjectionSource(final ServiceName serviceName) {
        this.serviceName = serviceName;
    }

    /** {@inheritDoc} */
    public void getResourceValue(final ResolutionContext resolutionContext, final ServiceBuilder<?> serviceBuilder, final DeploymentPhaseContext phaseContext, final Injector<ManagedReferenceFactory> injector) {
        serviceBuilder.addDependency(serviceName, ComponentView.class, new ViewManagedReferenceFactory.Injector(injector));
    }

    /** {@inheritDoc} */
    public boolean equals(final Object injectionSource) {
        return injectionSource instanceof ViewBindingInjectionSource && equals((ViewBindingInjectionSource) injectionSource);
    }

    private boolean equals(final ViewBindingInjectionSource configuration) {
        return configuration != null && serviceName.equals(configuration.serviceName);
    }

    public int hashCode() {
        return HASH_BASE + serviceName.hashCode();
    }
}
