/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.HashSet;
import java.util.List;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BasicComponent;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassDescriptionTraversal;
import org.jboss.as.ee.component.Component;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InterceptorDescription;
import org.jboss.as.ee.component.ViewConfiguration;
import org.jboss.as.ee.component.ViewService;
import org.jboss.as.ee.naming.RootContextService;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.modules.Module;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;

public final class ComponentInstallProcessor
implements DeploymentUnitProcessor {
    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (module == null) {
            return;
        }
        EEModuleConfiguration moduleDescription = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        for (ComponentConfiguration configuration : moduleDescription.getComponentConfigurations()) {
            try {
                this.deployComponent(phaseContext, configuration);
            }
            catch (RuntimeException e) {
                throw new DeploymentUnitProcessingException("Failed to install component " + configuration, (Throwable)e);
            }
        }
    }

    protected void deployComponent(final DeploymentPhaseContext phaseContext, final ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        ServiceName contextServiceName;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        final ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        String applicationName = configuration.getApplicationName();
        String moduleName = configuration.getModuleName();
        String componentName = configuration.getComponentName();
        ServiceName baseName = deploymentUnit.getServiceName().append(new String[]{"component"}).append(new String[]{componentName});
        ServiceName createServiceName = baseName.append(new String[]{"CREATE"});
        ServiceName startServiceName = baseName.append(new String[]{"START"});
        BasicComponentCreateService createService = configuration.getComponentCreateServiceFactory().constructService(configuration);
        ServiceBuilder createBuilder = serviceTarget.addService(createServiceName, (Service)createService);
        createBuilder.addDependency(deploymentUnit.getServiceName(), DeploymentUnit.class, createService.getDeploymentUnitInjector());
        ComponentStartService startService = new ComponentStartService();
        ServiceBuilder startBuilder = serviceTarget.addService(startServiceName, (Service)startService);
        EEModuleConfiguration moduleConfiguration = (EEModuleConfiguration)deploymentUnit.getAttachment(Attachments.EE_MODULE_CONFIGURATION);
        if (moduleConfiguration == null) {
            return;
        }
        for (DependencyConfigurator configurator : configuration.getCreateDependencies()) {
            configurator.configureDependency(createBuilder);
        }
        for (DependencyConfigurator configurator : configuration.getStartDependencies()) {
            configurator.configureDependency(startBuilder);
        }
        startBuilder.addDependency(createServiceName, BasicComponent.class, startService.getComponentInjector());
        if (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE) {
            RootContextService contextService = new RootContextService();
            contextServiceName = ContextNames.contextServiceNameOfComponent((String)configuration.getApplicationName(), (String)configuration.getModuleName(), (String)configuration.getComponentName());
            serviceTarget.addService(contextServiceName, (Service)contextService).install();
        } else {
            contextServiceName = ContextNames.contextServiceNameOfModule((String)configuration.getApplicationName(), (String)configuration.getModuleName());
        }
        final InjectionSource.ResolutionContext resolutionContext = new InjectionSource.ResolutionContext(configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.USE_MODULE, configuration.getComponentName(), configuration.getModuleName(), configuration.getApplicationName());
        for (ViewConfiguration viewConfiguration : configuration.getViews()) {
            ServiceName serviceName = viewConfiguration.getViewServiceName();
            ViewService viewService = new ViewService(viewConfiguration);
            serviceTarget.addService(serviceName, (Service)viewService).addDependency(createServiceName, Component.class, viewService.getComponentInjector()).install();
            for (BindingConfiguration bindingConfiguration : viewConfiguration.getBindingConfigurations()) {
                String bindingName = bindingConfiguration.getName();
                BinderService service = new BinderService(bindingName);
                ServiceBuilder serviceBuilder = serviceTarget.addService(ContextNames.serviceNameOfContext((String)applicationName, (String)moduleName, (String)componentName, (String)bindingName), (Service)service);
                bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
                serviceBuilder.addDependency(ContextNames.serviceNameOfNamingStore((String)applicationName, (String)moduleName, (String)componentName, (String)bindingName), NamingStore.class, service.getNamingStoreInjector());
                serviceBuilder.install();
            }
        }
        if (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE) {
            this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, resolutionContext, configuration.getBindingConfigurations());
            new ClassDescriptionTraversal(configuration.getModuleClassConfiguration(), moduleConfiguration){

                @Override
                protected void handle(EEModuleClassConfiguration classConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                    ComponentInstallProcessor.this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, resolutionContext, classConfiguration.getBindingConfigurations());
                }
            }.run();
            for (InterceptorDescription interceptor : configuration.getComponentDescription().getClassInterceptors()) {
                EEModuleClassConfiguration interceptorClass = moduleConfiguration.getClassConfiguration(interceptor.getInterceptorClassName());
                if (interceptorClass == null) continue;
                new ClassDescriptionTraversal(interceptorClass, moduleConfiguration){

                    @Override
                    protected void handle(EEModuleClassConfiguration classConfiguration, EEModuleClassDescription classDescription) throws DeploymentUnitProcessingException {
                        ComponentInstallProcessor.this.processBindings(phaseContext, configuration, serviceTarget, contextServiceName, resolutionContext, classConfiguration.getBindingConfigurations());
                    }
                }.run();
            }
        }
        createBuilder.install();
        startBuilder.install();
    }

    private void processBindings(DeploymentPhaseContext phaseContext, ComponentConfiguration configuration, ServiceTarget serviceTarget, ServiceName contextServiceName, InjectionSource.ResolutionContext resolutionContext, List<BindingConfiguration> bindings) throws DeploymentUnitProcessingException {
        HashSet<BindingConfiguration> uniqueBindings = new HashSet<BindingConfiguration>(bindings);
        for (BindingConfiguration bindingConfiguration : uniqueBindings) {
            if (!bindingConfiguration.getName().startsWith("java:comp") && bindingConfiguration.getName().startsWith("java:")) continue;
            String bindingName = bindingConfiguration.getName();
            BinderService service = new BinderService(bindingName);
            ServiceBuilder serviceBuilder = serviceTarget.addService(ContextNames.serviceNameOfEnvEntry((String)configuration.getApplicationName(), (String)configuration.getModuleName(), (String)configuration.getComponentName(), (configuration.getComponentDescription().getNamingMode() == ComponentNamingMode.CREATE ? 1 : 0) != 0, (String)bindingName), (Service)service);
            bindingConfiguration.getSource().getResourceValue(resolutionContext, serviceBuilder, phaseContext, (Injector<ManagedReferenceFactory>)service.getManagedObjectInjector());
            serviceBuilder.addDependency(contextServiceName, NamingStore.class, service.getNamingStoreInjector());
            serviceBuilder.install();
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

