/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Collection;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleConfiguration;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;

public class EEModuleConfigurationProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EEModuleConfigurationProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Collection<ComponentDescription> componentDescriptions;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (moduleDescription == null) {
            return;
        }
        if (module == null) {
            return;
        }
        EEModuleConfiguration moduleConfiguration = new EEModuleConfiguration(moduleDescription, phaseContext, module);
        deploymentUnit.putAttachment(Attachments.EE_MODULE_CONFIGURATION, (Object)moduleConfiguration);
        Collection<EEModuleClassDescription> classDescriptions = moduleDescription.getClassDescriptions();
        if (classDescriptions != null) {
            for (EEModuleClassDescription classDescription : classDescriptions) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(classDescription.getClassName(), false, (ClassLoader)module.getClassLoader());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Failed to load class " + classDescription.getClassName(), (Throwable)e);
                }
                EEModuleClassConfiguration classConfiguration = new EEModuleClassConfiguration(clazz, moduleConfiguration, classDescription);
                logger.debug((Object)("Configuring EE module class: " + clazz));
                for (ClassConfigurator classConfigurator : classDescription.getConfigurators()) {
                    classConfigurator.configure(phaseContext, classDescription, classConfiguration);
                }
                moduleConfiguration.addClassConfiguration(classConfiguration);
            }
        }
        if ((componentDescriptions = moduleDescription.getComponentDescriptions()) != null) {
            for (ComponentDescription componentDescription : componentDescriptions) {
                logger.debug((Object)("Configuring component class: " + componentDescription.getComponentClassName() + " named " + componentDescription.getComponentName()));
                ComponentConfiguration componentConfiguration = componentDescription.createConfiguration(moduleConfiguration);
                for (ComponentConfigurator componentConfigurator : componentDescription.getConfigurators()) {
                    componentConfigurator.configure(phaseContext, componentDescription, componentConfiguration);
                }
                moduleConfiguration.addComponentConfiguration(componentConfiguration);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

