/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.AbstractComponentConfiguration;
import org.jboss.as.ee.component.ResourceInjection;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.invocation.InterceptorInstanceFactory;
import org.jboss.invocation.SimpleInterceptorInstanceFactory;

public class InjectingInterceptorInstanceFactory
implements InterceptorInstanceFactory {
    private final SimpleInterceptorInstanceFactory delegate;
    private final Class<?> interceptorClass;
    private final AbstractComponentConfiguration componentConfiguration;

    public InjectingInterceptorInstanceFactory(SimpleInterceptorInstanceFactory delegate, Class<?> interceptorClass, AbstractComponentConfiguration componentConfiguration) {
        this.delegate = delegate;
        this.interceptorClass = interceptorClass;
        this.componentConfiguration = componentConfiguration;
    }

    public Object createInstance(InterceptorFactoryContext context) {
        Class<?> instanceClass;
        Map map = context.getContextData();
        if (map.containsKey(instanceClass = this.interceptorClass)) {
            return map.get(instanceClass);
        }
        Object instance = this.delegate.createInstance(context);
        List<ResourceInjection> interceptorInjections = this.componentConfiguration.getInterceptorResourceInjections(this.interceptorClass);
        if (interceptorInjections != null) {
            for (ResourceInjection injection : interceptorInjections) {
                injection.inject(instance);
            }
        }
        return instance;
    }
}

