/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import org.jboss.as.ee.component.AbstractComponentDescription;
import org.jboss.as.ee.component.BindingDescription;
import org.jboss.as.ee.component.BindingSourceDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.naming.ContextNames;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class LookupBindingSourceDescription
extends BindingSourceDescription {
    private final String lookupName;
    private final ServiceName sourceServiceName;

    public LookupBindingSourceDescription(String lookupJndiName, AbstractComponentDescription componentDescription) {
        this.lookupName = this.parseLookupName(lookupJndiName, componentDescription);
        String compName = componentDescription.getNamingMode() == ComponentNamingMode.CREATE ? componentDescription.getComponentName() : componentDescription.getModuleName();
        String moduleName = componentDescription.getModuleName();
        String appName = componentDescription.getApplicationName();
        this.sourceServiceName = ContextNames.serviceNameOfContext(appName, moduleName, compName, this.lookupName);
        if (this.sourceServiceName == null) {
            throw new IllegalArgumentException("Cannot find source service for lookup name: " + this.lookupName);
        }
    }

    public LookupBindingSourceDescription(String lookupJndiName, EEModuleDescription moduleDescription) {
        if (lookupJndiName.startsWith("java:comp/")) {
            String jndiNameSansNamespace = lookupJndiName.substring("java:comp/".length());
            this.lookupName = "java:module/" + jndiNameSansNamespace;
        } else {
            this.lookupName = lookupJndiName;
        }
        String compName = moduleDescription.getModuleName();
        String moduleName = moduleDescription.getModuleName();
        String appName = moduleDescription.getAppName();
        this.sourceServiceName = ContextNames.serviceNameOfContext(appName, moduleName, compName, this.lookupName);
        if (this.sourceServiceName == null) {
            throw new IllegalArgumentException("Cannot find source service for lookup name: " + this.lookupName);
        }
    }

    @Override
    public void getResourceValue(BindingDescription bindingDescription, ServiceBuilder<?> serviceBuilder, DeploymentPhaseContext phaseContext, Injector<ManagedReferenceFactory> injector) {
        serviceBuilder.addDependency(this.sourceServiceName, ManagedReferenceFactory.class, injector);
    }

    private String parseLookupName(String lookupName, AbstractComponentDescription componentDescription) {
        ComponentNamingMode namingMode = componentDescription.getNamingMode();
        if (namingMode != ComponentNamingMode.CREATE && lookupName.startsWith("java:comp/")) {
            String jndiNameSansNamespace = lookupName.substring("java:comp/".length());
            return "java:module/" + jndiNameSansNamespace;
        }
        return lookupName;
    }
}

