/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentConfigurator;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.ComponentNamingMode;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ee.component.NamespaceContextInterceptor;
import org.jboss.as.ee.naming.InjectedEENamespaceContextSelector;
import org.jboss.as.naming.NamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.invocation.ImmediateInterceptorFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;

public final class NamespaceConfigurator
implements ComponentConfigurator {
    @Override
    public void configure(DeploymentPhaseContext context, ComponentDescription description, ComponentConfiguration configuration) throws DeploymentUnitProcessingException {
        Injector<NamingStore> compInjector;
        final ComponentNamingMode namingMode = description.getNamingMode();
        InjectedEENamespaceContextSelector selector = new InjectedEENamespaceContextSelector();
        String applicationName = configuration.getApplicationName();
        String moduleName = configuration.getModuleName();
        String compName = configuration.getComponentName();
        final ServiceName appContextServiceName = ContextNames.contextServiceNameOfApplication((String)applicationName);
        final ServiceName moduleContextServiceName = ContextNames.contextServiceNameOfModule((String)applicationName, (String)moduleName);
        final ServiceName compContextServiceName = ContextNames.contextServiceNameOfComponent((String)applicationName, (String)moduleName, (String)compName);
        final Injector<NamingStore> appInjector = selector.getAppContextInjector();
        final Injector<NamingStore> moduleInjector = selector.getModuleContextInjector();
        switch (namingMode) {
            case USE_MODULE: {
                compInjector = moduleInjector;
                break;
            }
            case CREATE: {
                compInjector = selector.getCompContextInjector();
                break;
            }
            default: {
                compInjector = null;
            }
        }
        configuration.getStartDependencies().add(new DependencyConfigurator(){

            @Override
            public void configureDependency(ServiceBuilder<?> serviceBuilder) {
                serviceBuilder.addDependency(appContextServiceName, NamingStore.class, appInjector);
                serviceBuilder.addDependency(moduleContextServiceName, NamingStore.class, moduleInjector);
                if (namingMode == ComponentNamingMode.CREATE) {
                    serviceBuilder.addDependency(compContextServiceName, NamingStore.class, compInjector);
                }
            }
        });
        ImmediateInterceptorFactory interceptorFactory = new ImmediateInterceptorFactory((Interceptor)new NamespaceContextInterceptor(selector));
        configuration.getPostConstructInterceptors().addFirst((InterceptorFactory)interceptorFactory);
        configuration.getPreDestroyInterceptors().addFirst((InterceptorFactory)interceptorFactory);
        for (Method method : configuration.getDefinedComponentMethods()) {
            configuration.getComponentInterceptorDeque(method).addFirst((InterceptorFactory)interceptorFactory);
        }
    }
}

