/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.annotation.Resources;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.ComponentTypeInjectionSource;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.FieldInjectionTarget;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.ee.component.MethodInjectionTarget;
import org.jboss.as.ee.component.ResourceInjectionConfiguration;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;

public class ResourceInjectionAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static final DotName RESOURCE_ANNOTATION_NAME = DotName.createSimple((String)Resource.class.getName());
    private static final DotName RESOURCES_ANNOTATION_NAME = DotName.createSimple((String)Resources.class.getName());
    private static final Map<String, String> FIXED_LOCATIONS;

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        List resourceAnnotations = index.getAnnotations(RESOURCE_ANNOTATION_NAME);
        for (AnnotationInstance annotation : resourceAnnotations) {
            EEModuleClassDescription classDescription;
            ClassInfo classInfo;
            String type;
            AnnotationTarget annotationTarget = annotation.target();
            AnnotationValue nameValue = annotation.value("name");
            String name = nameValue != null ? nameValue.asString() : null;
            AnnotationValue typeValue = annotation.value("type");
            String string = type = typeValue != null ? typeValue.asClass().name().toString() : null;
            if (annotationTarget instanceof FieldInfo) {
                FieldInfo fieldInfo = (FieldInfo)annotationTarget;
                classInfo = fieldInfo.declaringClass();
                classDescription = eeModuleDescription.getOrAddClassByName(classInfo.name().toString());
                this.processFieldResource(fieldInfo, name, type, classDescription, annotation);
                continue;
            }
            if (annotationTarget instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)annotationTarget;
                classInfo = methodInfo.declaringClass();
                classDescription = eeModuleDescription.getOrAddClassByName(classInfo.name().toString());
                this.processMethodResource(methodInfo, name, type, classDescription, annotation);
                continue;
            }
            if (!(annotationTarget instanceof ClassInfo)) continue;
            ClassInfo classInfo2 = (ClassInfo)annotationTarget;
            EEModuleClassDescription classDescription2 = eeModuleDescription.getOrAddClassByName(classInfo2.name().toString());
            this.processClassResource(name, type, classDescription2, annotation);
        }
        List resourcesAnnotations = index.getAnnotations(RESOURCES_ANNOTATION_NAME);
        for (AnnotationInstance outerAnnotation : resourcesAnnotations) {
            AnnotationInstance[] values;
            AnnotationTarget annotationTarget = outerAnnotation.target();
            if (!(annotationTarget instanceof ClassInfo)) continue;
            ClassInfo classInfo = (ClassInfo)annotationTarget;
            for (AnnotationInstance annotation : values = outerAnnotation.value("value").asNestedArray()) {
                AnnotationValue nameValue = annotation.value("name");
                String name = nameValue != null ? nameValue.asString() : null;
                AnnotationValue typeValue = annotation.value("type");
                String type = typeValue != null ? typeValue.asClass().name().toString() : null;
                EEModuleClassDescription classDescription = eeModuleDescription.getOrAddClassByName(classInfo.name().toString());
                this.processClassResource(name, type, classDescription, annotation);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processFieldResource(FieldInfo fieldInfo, String name, String type, EEModuleClassDescription classDescription, AnnotationInstance annotation) {
        String fieldName = fieldInfo.name();
        String injectionType = this.isEmpty(type) || type.equals(Object.class.getName()) ? fieldInfo.type().name().toString() : type;
        String localContextName = this.isEmpty(name) ? fieldInfo.declaringClass().name().toString() + "/" + fieldName : name;
        FieldInjectionTarget targetDescription = new FieldInjectionTarget(fieldInfo.declaringClass().name().toString(), fieldName, injectionType);
        this.process(classDescription, annotation, injectionType, localContextName, targetDescription);
    }

    private void processMethodResource(MethodInfo methodInfo, String name, String type, EEModuleClassDescription classDescription, AnnotationInstance annotation) {
        String methodName = methodInfo.name();
        if (!methodName.startsWith("set") || methodInfo.args().length != 1) {
            throw new IllegalArgumentException("@Resource injection target is invalid.  Only setter methods are allowed: " + methodInfo);
        }
        String contextNameSuffix = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        String localContextName = this.isEmpty(name) ? methodInfo.declaringClass().name().toString() + "/" + contextNameSuffix : name;
        String injectionType = this.isEmpty(type) || type.equals(Object.class.getName()) ? methodInfo.args()[0].name().toString() : type;
        MethodInjectionTarget targetDescription = new MethodInjectionTarget(methodInfo.declaringClass().name().toString(), methodName, methodInfo.args()[0].name().toString());
        this.process(classDescription, annotation, injectionType, localContextName, targetDescription);
    }

    private void processClassResource(String name, String type, EEModuleClassDescription classDescription, AnnotationInstance annotation) {
        if (this.isEmpty(name)) {
            throw new IllegalArgumentException("Class level @Resource annotations must provide a name.");
        }
        if (this.isEmpty(type) || type.equals(Object.class.getName())) {
            throw new IllegalArgumentException("Class level @Resource annotations must provide a type.");
        }
        this.process(classDescription, annotation, type, name, null);
    }

    private void process(EEModuleClassDescription classDescription, AnnotationInstance annotation, String injectionType, String localContextName, InjectionTarget targetDescription) {
        String lookup;
        AnnotationValue lookupAnnotation = annotation.value("lookup");
        String string = lookup = lookupAnnotation == null ? null : lookupAnnotation.asString();
        if (this.isEmpty(lookup) && FIXED_LOCATIONS.containsKey(injectionType)) {
            lookup = FIXED_LOCATIONS.get(injectionType);
        }
        InjectionSource valueSource = this.isEmpty(lookup) ? new ComponentTypeInjectionSource(injectionType) : new LookupInjectionSource(lookup);
        final ResourceInjectionConfiguration injectionConfiguration = targetDescription != null ? new ResourceInjectionConfiguration(targetDescription, new LookupInjectionSource(localContextName)) : null;
        final BindingConfiguration bindingConfiguration = new BindingConfiguration(localContextName, valueSource);
        classDescription.getConfigurators().add(new ClassConfigurator(){

            @Override
            public void configure(DeploymentPhaseContext context, EEModuleClassDescription description, EEModuleClassConfiguration configuration) throws DeploymentUnitProcessingException {
                configuration.getBindingConfigurations().add(bindingConfiguration);
                if (injectionConfiguration != null) {
                    configuration.getInjectionConfigurations().add(injectionConfiguration);
                }
            }
        });
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    static {
        HashMap<String, String> locations = new HashMap<String, String>();
        locations.put("javax.transaction.UserTransaction", "java:comp/UserTransaction");
        locations.put("javax.transaction.TransactionSynchronizationRegistry", "java:comp/TransactionSynchronizationRegistry");
        locations.put("javax.enterprise.inject.spi.BeanManager", "java:comp/BeanManager");
        locations.put("javax.validation.Validator", "java:comp/Validator");
        locations.put("javax.validation.ValidationFactory", "java:comp/ValidationFactory");
        locations.put("javax.ejb.EJBContext", "java:comp/EJBContext");
        locations.put("javax.ejb.SessionContext", "java:comp/EJBContext");
        locations.put("org.omg.CORBA.ORB", "java:comp/ORB");
        FIXED_LOCATIONS = Collections.unmodifiableMap(locations);
    }
}

