/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.List;
import org.jboss.as.ee.component.AbstractDeploymentDescriptorBindingsProcessor;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentDescription;
import org.jboss.as.ee.component.DeploymentDescriptorEnvironment;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.EnvEntryInjectionSource;
import org.jboss.as.ee.component.LookupInjectionSource;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.metadata.javaee.spec.EnvironmentEntriesMetaData;
import org.jboss.metadata.javaee.spec.EnvironmentEntryMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceEnvironmentReferencesMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferenceMetaData;
import org.jboss.metadata.javaee.spec.ResourceReferencesMetaData;
import org.jboss.metadata.javaee.support.ResourceInjectionMetaDataWithDescriptions;

public class ResourceReferenceProcessor
extends AbstractDeploymentDescriptorBindingsProcessor {
    @Override
    protected List<BindingConfiguration> processDescriptorEntries(DeploymentUnit deploymentUnit, DeploymentDescriptorEnvironment environment, EEModuleDescription moduleDescription, ComponentDescription componentDescription, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        bindings.addAll(this.getEnvironmentEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        bindings.addAll(this.getResourceEnvRefEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        bindings.addAll(this.getResourceRefEntries(environment, classLoader, deploymentReflectionIndex, moduleDescription, componentDescription));
        return bindings;
    }

    private List<BindingConfiguration> getResourceEnvRefEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        ResourceEnvironmentReferencesMetaData entries = environment.getEnvironment().getResourceEnvironmentReferences();
        if (entries == null) {
            return bindings;
        }
        for (ResourceEnvironmentReferenceMetaData envEntry : entries) {
            LookupInjectionSource injectionSource;
            String name = envEntry.getName().startsWith("java:") ? envEntry.getName() : environment.getDefaultContext() + envEntry.getName();
            Class<?> classType = null;
            if (envEntry.getType() != null) {
                try {
                    classType = classLoader.loadClass(envEntry.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + envEntry.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            if ((classType = this.processInjectionTargets(moduleDescription, injectionSource = new LookupInjectionSource(name), classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)envEntry, classType)) == null) {
                throw new DeploymentUnitProcessingException("Could not determine type for resource-env-ref " + name);
            }
            BindingConfiguration bindingConfiguration = null;
            if (this.isEmpty(envEntry.getLookupName())) {
                throw new RuntimeException("res-env-ref without a lookup-name isn't yet supported");
            }
            bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(envEntry.getLookupName()));
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private List<BindingConfiguration> getResourceRefEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        ResourceReferencesMetaData entries = environment.getEnvironment().getResourceReferences();
        if (entries == null) {
            return bindings;
        }
        for (ResourceReferenceMetaData envEntry : entries) {
            LookupInjectionSource injectionSource;
            String name = envEntry.getName().startsWith("java:") ? envEntry.getName() : environment.getDefaultContext() + envEntry.getName();
            Class<?> classType = null;
            if (envEntry.getType() != null) {
                try {
                    classType = classLoader.loadClass(envEntry.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + envEntry.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            if ((classType = this.processInjectionTargets(moduleDescription, injectionSource = new LookupInjectionSource(name), classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)envEntry, classType)) == null) {
                throw new DeploymentUnitProcessingException("Could not determine type for resource-ref " + name);
            }
            BindingConfiguration bindingConfiguration = null;
            if (this.isEmpty(envEntry.getLookupName())) {
                throw new RuntimeException("resource-ref without a lookup-name isn't yet supported");
            }
            bindingConfiguration = new BindingConfiguration(name, new LookupInjectionSource(envEntry.getLookupName()));
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private List<BindingConfiguration> getEnvironmentEntries(DeploymentDescriptorEnvironment environment, ClassLoader classLoader, DeploymentReflectionIndex deploymentReflectionIndex, EEModuleDescription moduleDescription, ComponentDescription componentDescription) throws DeploymentUnitProcessingException {
        ArrayList<BindingConfiguration> bindings = new ArrayList<BindingConfiguration>();
        EnvironmentEntriesMetaData entries = environment.getEnvironment().getEnvironmentEntries();
        if (entries == null) {
            return bindings;
        }
        for (EnvironmentEntryMetaData envEntry : entries) {
            LookupInjectionSource injectionSource;
            String name = envEntry.getName().startsWith("java:") ? envEntry.getName() : environment.getDefaultContext() + envEntry.getEnvEntryName();
            Class<?> classType = null;
            if (envEntry.getType() != null) {
                try {
                    classType = classLoader.loadClass(envEntry.getType());
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load " + envEntry.getType() + " referenced in env-entry ", (Throwable)e);
                }
            }
            if ((classType = this.processInjectionTargets(moduleDescription, injectionSource = new LookupInjectionSource(name), classLoader, deploymentReflectionIndex, (ResourceInjectionMetaDataWithDescriptions)envEntry, classType)) == null) {
                throw new DeploymentUnitProcessingException("Could not determine type for <env-entry> " + name + " please specify the <env-entry-type>.");
            }
            String value = envEntry.getValue();
            if (this.isEmpty(value)) continue;
            String type = classType.getName();
            BindingConfiguration bindingConfiguration = null;
            if (type.equals(String.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(value));
            } else if (type.equals(Integer.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Integer.valueOf(value)));
            } else if (type.equals(Short.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Short.valueOf(value)));
            } else if (type.equals(Long.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Long.valueOf(value)));
            } else if (type.equals(Byte.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Byte.valueOf(value)));
            } else if (type.equals(Double.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Double.valueOf(value)));
            } else if (type.equals(Float.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Float.valueOf(value)));
            } else if (type.equals(Boolean.class.getName())) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Boolean.valueOf(value)));
            } else if (type.equals(Character.class.getName())) {
                if (value.length() != 1) {
                    throw new DeploymentUnitProcessingException("env-entry of type java.lang.Character is not exactly one character long " + value);
                }
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Character.valueOf(value.charAt(0))));
            } else if (type.equals(Class.class.getName())) {
                try {
                    bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(classLoader.loadClass(value)));
                }
                catch (ClassNotFoundException e) {
                    throw new DeploymentUnitProcessingException("Could not load class " + value + " specified in env-entry");
                }
            } else if (classType.isEnum() || classType.getEnclosingClass() != null && classType.getEnclosingClass().isEnum()) {
                bindingConfiguration = new BindingConfiguration(name, new EnvEntryInjectionSource(Enum.valueOf(classType, value)));
            } else {
                throw new DeploymentUnitProcessingException("Unkown env-entry type " + type);
            }
            bindings.add(bindingConfiguration);
        }
        return bindings;
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    @Override
    public void undeploy(DeploymentUnit context) {
    }
}

