/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.service.ServiceName;

public class ViewConfiguration {
    private final ComponentConfiguration componentConfiguration;
    private final ServiceName viewServiceName;
    private final Map<Method, Deque<InterceptorFactory>> viewInterceptors = new IdentityHashMap<Method, Deque<InterceptorFactory>>();
    private final Map<Method, Deque<InterceptorFactory>> clientInterceptors = new IdentityHashMap<Method, Deque<InterceptorFactory>>();
    private final Deque<InterceptorFactory> viewPostConstructInterceptors = new ArrayDeque<InterceptorFactory>();
    private final Deque<InterceptorFactory> clientPostConstructInterceptors = new ArrayDeque<InterceptorFactory>();
    private final Deque<InterceptorFactory> viewPreDestroyInterceptors = new ArrayDeque<InterceptorFactory>();
    private final Deque<InterceptorFactory> clientPreDestroyInterceptors = new ArrayDeque<InterceptorFactory>();
    private final ProxyFactory<?> proxyFactory;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final Class<?> viewClass;

    public ViewConfiguration(Class<?> viewClass, ComponentConfiguration componentConfiguration, ServiceName viewServiceName, ProxyFactory<?> proxyFactory) {
        this.componentConfiguration = componentConfiguration;
        this.viewServiceName = viewServiceName;
        this.proxyFactory = proxyFactory;
        this.viewClass = viewClass;
    }

    public ComponentConfiguration getComponentConfiguration() {
        return this.componentConfiguration;
    }

    public ServiceName getViewServiceName() {
        return this.viewServiceName;
    }

    public Deque<InterceptorFactory> getViewInterceptorDeque(Method method) {
        Map<Method, Deque<InterceptorFactory>> map = this.viewInterceptors;
        Deque<InterceptorFactory> deque = map.get(method);
        if (deque == null) {
            deque = new ArrayDeque<InterceptorFactory>();
            map.put(method, deque);
        }
        return deque;
    }

    public Deque<InterceptorFactory> getClientInterceptorDeque(Method method) {
        Map<Method, Deque<InterceptorFactory>> map = this.clientInterceptors;
        Deque<InterceptorFactory> deque = map.get(method);
        if (deque == null) {
            deque = new ArrayDeque<InterceptorFactory>();
            map.put(method, deque);
        }
        return deque;
    }

    public Deque<InterceptorFactory> getViewPostConstructInterceptors() {
        return this.viewPostConstructInterceptors;
    }

    public Deque<InterceptorFactory> getClientPostConstructInterceptors() {
        return this.clientPostConstructInterceptors;
    }

    public Deque<InterceptorFactory> getViewPreDestroyInterceptors() {
        return this.viewPreDestroyInterceptors;
    }

    public Deque<InterceptorFactory> getClientPreDestroyInterceptors() {
        return this.clientPreDestroyInterceptors;
    }

    public ProxyFactory<?> getProxyFactory() {
        return this.proxyFactory;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public Class<?> getViewClass() {
        return this.viewClass;
    }

    public void addViewInterceptorToFront(InterceptorFactory interceptorFactory) {
        Method[] allMethodsOnView;
        for (Method method : allMethodsOnView = this.proxyFactory.getCachedMethods()) {
            Deque<InterceptorFactory> interceptorsForMethod = this.getViewInterceptorDeque(method);
            interceptorsForMethod.addFirst(interceptorFactory);
        }
    }

    public void addViewInterceptorToBack(InterceptorFactory interceptorFactory) {
        Method[] allMethodsOnView;
        for (Method method : allMethodsOnView = this.proxyFactory.getCachedMethods()) {
            Deque<InterceptorFactory> interceptorsForMethod = this.getViewInterceptorDeque(method);
            interceptorsForMethod.addFirst(interceptorFactory);
        }
    }

    public void addClientViewInterceptor(InterceptorFactory interceptorFactory) {
        Method[] allMethodsOnView;
        for (Method method : allMethodsOnView = this.proxyFactory.getCachedMethods()) {
            Deque<InterceptorFactory> interceptorsForMethod = this.getClientInterceptorDeque(method);
            interceptorsForMethod.add(interceptorFactory);
        }
    }
}

