/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.ClassConfigurator;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEApplicationDescription;
import org.jboss.as.ee.component.EEModuleClassConfiguration;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.LazyValue;
import org.jboss.as.ee.component.SecurityActions;
import org.jboss.as.ee.structure.DeploymentType;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;

public class EEClassConfigurationProcessor
implements DeploymentUnitProcessor {
    private static final Logger logger = Logger.getLogger(EEClassConfigurationProcessor.class);

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        Collection<EEModuleClassDescription> classDescriptions;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationDescription applicationDescription = (EEApplicationDescription)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Module module = (Module)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        if (moduleDescription == null) {
            return;
        }
        if (module == null) {
            return;
        }
        DeploymentReflectionIndex deploymentReflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.REFLECTION_INDEX);
        HashSet<String> processed = new HashSet<String>();
        if (deploymentUnit.getAttachment(org.jboss.as.ee.structure.Attachments.DEPLOYMENT_TYPE) == DeploymentType.EAR) {
            List subdeployments = deploymentUnit.getAttachmentList(org.jboss.as.server.deployment.Attachments.SUB_DEPLOYMENTS);
            for (DeploymentUnit subdeployment : subdeployments) {
                this.processClasses(phaseContext, applicationDescription, deploymentReflectionIndex, subdeployment, processed);
            }
            this.processClasses(phaseContext, applicationDescription, deploymentReflectionIndex, deploymentUnit, processed);
        } else if (deploymentUnit.getParent() == null && (classDescriptions = applicationClasses.getClassDescriptions()) != null) {
            for (EEModuleClassDescription classDescription : classDescriptions) {
                this.handleClassDescription(phaseContext, applicationDescription, deploymentReflectionIndex, processed, module, classDescription);
            }
        }
    }

    private void processClasses(DeploymentPhaseContext phaseContext, EEApplicationDescription applicationDescription, DeploymentReflectionIndex deploymentReflectionIndex, DeploymentUnit subdeployment, Set<String> processed) throws DeploymentUnitProcessingException {
        EEModuleDescription subModuleDescription = (EEModuleDescription)subdeployment.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (subModuleDescription == null) {
            return;
        }
        Module subModule = (Module)subdeployment.getAttachment(org.jboss.as.server.deployment.Attachments.MODULE);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)subdeployment.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        Collection<EEModuleClassDescription> classDescriptions = applicationClasses.getClassDescriptions();
        if (classDescriptions != null) {
            for (EEModuleClassDescription classDescription : classDescriptions) {
                this.handleClassDescription(phaseContext, applicationDescription, deploymentReflectionIndex, processed, subModule, classDescription);
            }
        }
    }

    private void handleClassDescription(final DeploymentPhaseContext phaseContext, EEApplicationDescription applicationDescription, final DeploymentReflectionIndex deploymentReflectionIndex, Set<String> processed, final Module subModule, final EEModuleClassDescription classDescription) {
        if (processed.contains(classDescription.getClassName())) {
            return;
        }
        processed.add(classDescription.getClassName());
        LazyValue<EEModuleClassConfiguration> future = new LazyValue<EEModuleClassConfiguration>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected EEModuleClassConfiguration compute() {
                Class<?> clazz = null;
                ClassLoader oldCl = SecurityActions.getContextClassLoader();
                try {
                    SecurityActions.setContextClassLoader((ClassLoader)subModule.getClassLoader());
                    try {
                        clazz = Class.forName(classDescription.getClassName(), false, (ClassLoader)subModule.getClassLoader());
                    }
                    catch (ClassNotFoundException e) {
                        classDescription.setInvalid("Failed to load class " + classDescription.getClassName() + e.getMessage());
                        logger.debug((Object)("Failed to load class " + classDescription.getClassName()), (Throwable)e);
                        EEModuleClassConfiguration eEModuleClassConfiguration = null;
                        SecurityActions.setContextClassLoader(oldCl);
                        return eEModuleClassConfiguration;
                    }
                    EEModuleClassConfiguration classConfiguration = new EEModuleClassConfiguration(clazz, classDescription, deploymentReflectionIndex);
                    logger.debug((Object)("Configuring EE module class: " + clazz));
                    for (ClassConfigurator classConfigurator : classDescription.getConfigurators()) {
                        try {
                            classConfigurator.configure(phaseContext, classDescription, classConfiguration);
                        }
                        catch (DeploymentUnitProcessingException e) {
                            throw new RuntimeException(e);
                        }
                    }
                    EEModuleClassConfiguration eEModuleClassConfiguration = classConfiguration;
                    return eEModuleClassConfiguration;
                }
                finally {
                    SecurityActions.setContextClassLoader(oldCl);
                }
            }
        };
        applicationDescription.addClass(classDescription.getClassName(), future);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

