/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.InvocationContext;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;
import org.jboss.invocation.proxy.MethodIdentifier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class LifecycleAnnotationParsingProcessor
implements DeploymentUnitProcessor {
    private static Logger log = Logger.getLogger(LifecycleAnnotationParsingProcessor.class);
    private static final DotName POST_CONSTRUCT_ANNOTATION = DotName.createSimple((String)PostConstruct.class.getName());
    private static final DotName PRE_DESTROY_ANNOTATION = DotName.createSimple((String)PreDestroy.class.getName());
    private static DotName[] LIFE_CYCLE_ANNOTATIONS = new DotName[]{POST_CONSTRUCT_ANNOTATION, PRE_DESTROY_ANNOTATION};

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEModuleDescription eeModuleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        for (DotName annotationName : LIFE_CYCLE_ANNOTATIONS) {
            List lifecycles = index.getAnnotations(annotationName);
            for (AnnotationInstance annotation : lifecycles) {
                this.processLifeCycle(eeModuleDescription, annotation.target(), annotationName, applicationClasses);
            }
        }
    }

    public void undeploy(DeploymentUnit context) {
    }

    private void processLifeCycle(EEModuleDescription eeModuleDescription, AnnotationTarget target, DotName annotationType, EEApplicationClasses applicationClasses) {
        if (!(target instanceof MethodInfo)) {
            throw new IllegalArgumentException(annotationType + " is only valid on method targets.");
        }
        MethodInfo methodInfo = (MethodInfo)MethodInfo.class.cast(target);
        ClassInfo classInfo = methodInfo.declaringClass();
        EEModuleClassDescription classDescription = applicationClasses.getOrAddClassByName(classInfo.name().toString());
        Type[] args = methodInfo.args();
        if (args.length > 1) {
            log.warn((Object)("Invalid number of arguments for method " + methodInfo.name() + " annotated with " + annotationType + " on class " + classInfo.name()));
            return;
        }
        if (args.length == 1 && !args[0].name().toString().equals(InvocationContext.class.getName())) {
            log.warn((Object)("Invalid signature for method " + methodInfo.name() + " annotated with " + annotationType + " on class " + classInfo.name() + ", signature must be void methodName(InvocationContext ctx)"));
            return;
        }
        MethodIdentifier methodIdentifier = args.length == 0 ? MethodIdentifier.getIdentifier(Void.TYPE, (String)methodInfo.name(), (Class[])new Class[0]) : MethodIdentifier.getIdentifier(Void.TYPE, (String)methodInfo.name(), (Class[])new Class[]{InvocationContext.class});
        if (annotationType == POST_CONSTRUCT_ANNOTATION) {
            classDescription.setPostConstructMethod(methodIdentifier);
        } else {
            classDescription.setPreDestroyMethod(methodIdentifier);
        }
    }
}

