/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.datasource;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;

public class DataSourceTransactionProxyHandler
implements InvocationHandler,
Synchronization {
    private final TransactionManager transactionManager;
    private final TransactionSynchronizationRegistry synchronizationRegistry;
    private final Object delegate;
    private final ThreadLocal<Boolean> synchronizationRegistered = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };

    public DataSourceTransactionProxyHandler(Object delegate, TransactionManager transactionManager, TransactionSynchronizationRegistry synchronizationRegistry) {
        this.transactionManager = transactionManager;
        this.delegate = delegate;
        this.synchronizationRegistry = synchronizationRegistry;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("getConnection") && method.getParameterTypes().length == 0 && this.delegate instanceof XADataSource) {
            XADataSource xa = (XADataSource)this.delegate;
            XAConnection xacon = xa.getXAConnection();
            if (!this.synchronizationRegistered.get().booleanValue() && this.transactionManager.getTransaction() != null && this.transactionActive(this.transactionManager.getTransaction().getStatus())) {
                this.transactionManager.getTransaction().enlistResource(xacon.getXAResource());
                this.synchronizationRegistry.registerInterposedSynchronization((Synchronization)this);
                this.synchronizationRegistered.set(true);
            }
            return xacon.getConnection();
        }
        Object ret = method.invoke(this.delegate, args);
        return ret;
    }

    private boolean transactionActive(int status) {
        switch (status) {
            case 0: 
            case 1: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public void beforeCompletion() {
    }

    public void afterCompletion(int status) {
        this.synchronizationRegistered.remove();
    }
}

