/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.LazyResourceInjection;

public final class EEApplicationClasses {
    private final ConcurrentMap<String, EEModuleClassDescription> classesByName = new ConcurrentHashMap<String, EEModuleClassDescription>();
    private final EEApplicationClasses parent;
    private final Map<String, List<LazyResourceInjection>> lazyResourceInjections = Collections.synchronizedMap(new HashMap());

    public EEApplicationClasses(EEApplicationClasses parent) {
        this.parent = parent;
    }

    public EEApplicationClasses() {
        this.parent = null;
    }

    public EEModuleClassDescription getClassByName(String name) {
        return (EEModuleClassDescription)this.classesByName.get(name);
    }

    public EEModuleClassDescription getOrAddClassByName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        EEModuleClassDescription description = (EEModuleClassDescription)this.classesByName.get(name);
        if (description == null && this.parent != null) {
            description = this.parent.getOrAddClassByName(name);
            this.classesByName.put(name, description);
        } else {
            description = new EEModuleClassDescription(name);
            EEModuleClassDescription existing = this.classesByName.putIfAbsent(name, description);
            if (existing != null) {
                return existing;
            }
        }
        return description;
    }

    public void addLazyResourceInjection(LazyResourceInjection injection) {
        if (this.parent != null) {
            this.parent.addLazyResourceInjection(injection);
            return;
        }
        String name = injection.getLocalContextName();
        if (!name.startsWith("java:")) {
            List<LazyResourceInjection> list = this.lazyResourceInjections.get("java:comp/env/" + name);
            if (list == null) {
                list = new ArrayList<LazyResourceInjection>(1);
                this.lazyResourceInjections.put("java:comp/env/" + name, list);
            }
            list.add(injection);
            list = this.lazyResourceInjections.get("java:module/env/" + name);
            if (list == null) {
                list = new ArrayList<LazyResourceInjection>(1);
                this.lazyResourceInjections.put("java:module/env/" + name, list);
            }
            list.add(injection);
        } else {
            List<LazyResourceInjection> list = this.lazyResourceInjections.get(name);
            if (list == null) {
                list = new ArrayList<LazyResourceInjection>(1);
                this.lazyResourceInjections.put(name, list);
            }
            list.add(injection);
        }
    }

    public Map<String, List<LazyResourceInjection>> getLazyResourceInjections() {
        if (this.parent != null) {
            return this.parent.getLazyResourceInjections();
        }
        return this.lazyResourceInjections;
    }

    public Collection<EEModuleClassDescription> getClassDescriptions() {
        return this.classesByName.values();
    }
}

