/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.naming.ManagedReference;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.Interceptors;

final class ManagedReferenceMethodInterceptor
implements Interceptor {
    private final AtomicReference<ManagedReference> instanceRef;
    private final Method method;

    ManagedReferenceMethodInterceptor(AtomicReference<ManagedReference> instanceRef, Method method) {
        this.method = method;
        this.instanceRef = instanceRef;
    }

    public Object processInvocation(InterceptorContext context) throws Exception {
        ManagedReference reference = this.instanceRef.get();
        Object instance = reference.getInstance();
        try {
            return this.method.invoke(instance, context.getParameters());
        }
        catch (IllegalAccessException e) {
            IllegalAccessError n = new IllegalAccessError(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
        catch (InvocationTargetException e) {
            throw Interceptors.rethrow((Throwable)e.getCause());
        }
    }
}

