/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.managedbean.component;

import org.jboss.as.ee.component.ComponentTypeInjectionSource;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.ee.component.InjectionSource;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.deployers.EEResourceReferenceProcessor;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.logging.Logger;

public class ManagedBeanResourceReferenceProcessor
implements EEResourceReferenceProcessor {
    private static final Logger logger = Logger.getLogger(ManagedBeanResourceReferenceProcessor.class);
    private final String managedBeanClassName;

    public ManagedBeanResourceReferenceProcessor(String managedBeanClassName) {
        if (managedBeanClassName == null || managedBeanClassName.trim().isEmpty()) {
            throw new IllegalArgumentException("Managed bean classname cannot be null or empty: " + managedBeanClassName);
        }
        this.managedBeanClassName = managedBeanClassName;
    }

    @Override
    public String getResourceReferenceType() {
        return this.managedBeanClassName;
    }

    @Override
    public InjectionSource getResourceReferenceBindingSource(DeploymentPhaseContext phaseContext, EEModuleDescription eeModuleDescription, EEModuleClassDescription classDescription, String resourceReferenceType, String localContextName, InjectionTarget injectionTarget) throws DeploymentUnitProcessingException {
        logger.debug((Object)("Processing @Resource of type: " + this.managedBeanClassName + " for ENC name: " + localContextName));
        ComponentTypeInjectionSource bindingSource = new ComponentTypeInjectionSource(this.managedBeanClassName);
        return bindingSource;
    }
}

