/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.metadata;

import java.util.List;
import java.util.Map;
import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEApplicationClasses;
import org.jboss.as.ee.component.EEModuleClassDescription;
import org.jboss.as.ee.metadata.ClassAnnotationInformationFactory;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.annotation.CompositeIndex;

public abstract class AbstractEEAnnotationProcessor
implements DeploymentUnitProcessor {
    public final void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        EEApplicationClasses applicationClasses = (EEApplicationClasses)deploymentUnit.getAttachment(Attachments.EE_APPLICATION_CLASSES_DESCRIPTION);
        CompositeIndex index = (CompositeIndex)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.COMPOSITE_ANNOTATION_INDEX);
        if (index == null || applicationClasses == null) {
            return;
        }
        List<ClassAnnotationInformationFactory> factories = this.annotationInformationFactories();
        for (ClassAnnotationInformationFactory factory : factories) {
            Map data = factory.createAnnotationInformation(index);
            for (Map.Entry entry : data.entrySet()) {
                EEModuleClassDescription clazz = applicationClasses.getOrAddClassByName(entry.getKey());
                clazz.addAnnotationInformation(entry.getValue());
            }
        }
        this.afterAnnotationsProcessed(phaseContext, deploymentUnit);
    }

    protected void afterAnnotationsProcessed(DeploymentPhaseContext phaseContext, DeploymentUnit deploymentUnit) {
    }

    protected abstract List<ClassAnnotationInformationFactory> annotationInformationFactories();

    public void undeploy(DeploymentUnit context) {
    }
}

