/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import java.util.Locale;
import java.util.ResourceBundle;
import org.jboss.as.ee.subsystem.CommonAttributes;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.dmr.ModelNode;

class EeSubsystemDescriptions {
    static final String RESOURCE_NAME = EeSubsystemDescriptions.class.getPackage().getName() + ".LocalDescriptions";

    EeSubsystemDescriptions() {
    }

    public static final ModelNode getSubsystemDescription(Locale locale) {
        ResourceBundle bundle = EeSubsystemDescriptions.getResourceBundle(locale);
        ModelNode subsystem = new ModelNode();
        subsystem.get("description").set(bundle.getString("ee"));
        subsystem.get("head-comment-allowed").set(true);
        subsystem.get("tail-comment-allowed").set(true);
        subsystem.get("namespace").set("urn:jboss:domain:ee:1.0");
        CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.addResourceAttributeDescription(bundle, "ee", subsystem);
        GlobalModulesDefinition.INSTANCE.addResourceAttributeDescription(bundle, "ee", subsystem);
        subsystem.get("operations");
        subsystem.get("children").setEmptyObject();
        return subsystem;
    }

    public static final ModelNode getSubsystemAdd(Locale locale) {
        ResourceBundle bundle = EeSubsystemDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("add");
        op.get("description").set(bundle.getString("ee.add"));
        CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.addOperationParameterDescription(bundle, "ee", op);
        GlobalModulesDefinition.INSTANCE.addOperationParameterDescription(bundle, "ee", op);
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    public static final ModelNode getSubsystemRemove(Locale locale) {
        ResourceBundle bundle = EeSubsystemDescriptions.getResourceBundle(locale);
        ModelNode op = new ModelNode();
        op.get("operation-name").set("remove");
        op.get("description").set(bundle.getString("ee.remove"));
        op.get("request-properties").setEmptyObject();
        op.get("reply-properties").setEmptyObject();
        return op;
    }

    private static ResourceBundle getResourceBundle(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return ResourceBundle.getBundle(RESOURCE_NAME, locale);
    }
}

