/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.subsystem;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.ee.component.deployers.DefaultEarSubDeploymentsIsolationProcessor;
import org.jboss.as.ee.structure.GlobalModuleDependencyProcessor;
import org.jboss.as.ee.subsystem.CommonAttributes;
import org.jboss.as.ee.subsystem.GlobalModulesDefinition;
import org.jboss.as.server.operations.ServerWriteAttributeOperationHandler;
import org.jboss.dmr.ModelNode;

public class EeWriteAttributeHandler
extends ServerWriteAttributeOperationHandler {
    private final DefaultEarSubDeploymentsIsolationProcessor isolationProcessor;
    private final GlobalModuleDependencyProcessor moduleDependencyProcessor;

    public EeWriteAttributeHandler(DefaultEarSubDeploymentsIsolationProcessor isolationProcessor, GlobalModuleDependencyProcessor moduleDependencyProcessor) {
        this.isolationProcessor = isolationProcessor;
        this.moduleDependencyProcessor = moduleDependencyProcessor;
    }

    public void registerAttributes(ManagementResourceRegistration registry) {
        registry.registerReadWriteAttribute(GlobalModulesDefinition.INSTANCE.getName(), null, (OperationStepHandler)this, AttributeAccess.Storage.CONFIGURATION);
        registry.registerReadWriteAttribute(CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.getName(), null, (OperationStepHandler)this, AttributeAccess.Storage.CONFIGURATION);
    }

    protected void validateValue(String name, ModelNode value) throws OperationFailedException {
        if (GlobalModulesDefinition.INSTANCE.getName().equals(name)) {
            GlobalModulesDefinition.INSTANCE.getValidator().validateParameter(name, value);
        } else if (CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.getName().equals(name)) {
            CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.getValidator().validateParameter(name, value);
        }
    }

    protected void validateResolvedValue(String name, ModelNode value) throws OperationFailedException {
        if (GlobalModulesDefinition.INSTANCE.getName().equals(name)) {
            GlobalModulesDefinition.INSTANCE.getValidator().validateResolvedParameter(name, value);
        } else if (CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.getName().equals(name)) {
            CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.getValidator().validateResolvedParameter(name, value);
        }
    }

    protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode newValue, ModelNode currentValue) throws OperationFailedException {
        this.applyUpdateToDeploymentUnitProcessor(operation, attributeName);
        return false;
    }

    protected void revertUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode valueToRestore, ModelNode valueToRevert) throws OperationFailedException {
        ModelNode revertOp = operation.clone();
        revertOp.get(attributeName).set(valueToRestore);
        this.applyUpdateToDeploymentUnitProcessor(revertOp, attributeName);
    }

    private void applyUpdateToDeploymentUnitProcessor(ModelNode operation, String attributeName) throws OperationFailedException {
        if (GlobalModulesDefinition.INSTANCE.getName().equals(attributeName)) {
            ModelNode globalMods = GlobalModulesDefinition.INSTANCE.validateResolvedOperation(operation);
            this.moduleDependencyProcessor.setGlobalModules(globalMods);
        } else if (CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.getName().equals(attributeName)) {
            boolean isolate = CommonAttributes.EAR_SUBDEPLOYMENTS_ISOLATED.validateResolvedOperation(operation).asBoolean();
            this.isolationProcessor.setEarSubDeploymentsIsolated(isolate);
        }
    }
}

