/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.as.ee.component.BindingConfiguration;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ViewInstanceFactory;
import org.jboss.as.ee.component.interceptors.OrderedItemContainer;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.proxy.ProxyFactory;
import org.jboss.msc.service.ServiceName;

public class ViewConfiguration {
    private final ComponentConfiguration componentConfiguration;
    private final ServiceName viewServiceName;
    private final Map<Method, OrderedItemContainer<InterceptorFactory>> viewInterceptors = new IdentityHashMap<Method, OrderedItemContainer<InterceptorFactory>>();
    private final Map<Method, OrderedItemContainer<InterceptorFactory>> clientInterceptors = new IdentityHashMap<Method, OrderedItemContainer<InterceptorFactory>>();
    private final OrderedItemContainer<InterceptorFactory> clientPostConstructInterceptors = new OrderedItemContainer();
    private final OrderedItemContainer<InterceptorFactory> clientPreDestroyInterceptors = new OrderedItemContainer();
    private final ProxyFactory<?> proxyFactory;
    private final List<BindingConfiguration> bindingConfigurations = new ArrayList<BindingConfiguration>();
    private final Class<?> viewClass;
    private final Set<Method> asyncMethods = new HashSet<Method>();
    private final Map<Class<?>, Object> privateData = new HashMap();
    private ViewInstanceFactory viewInstanceFactory;

    public ViewConfiguration(Class<?> viewClass, ComponentConfiguration componentConfiguration, ServiceName viewServiceName, ProxyFactory<?> proxyFactory) {
        this.componentConfiguration = componentConfiguration;
        this.viewServiceName = viewServiceName;
        this.proxyFactory = proxyFactory;
        this.viewClass = viewClass;
    }

    public ComponentConfiguration getComponentConfiguration() {
        return this.componentConfiguration;
    }

    public ServiceName getViewServiceName() {
        return this.viewServiceName;
    }

    public List<InterceptorFactory> getViewInterceptors(Method method) {
        OrderedItemContainer<InterceptorFactory> container = this.viewInterceptors.get(method);
        if (container == null) {
            return Collections.emptyList();
        }
        return container.getSortedItems();
    }

    public void addViewInterceptor(InterceptorFactory interceptorFactory, int priority) {
        for (Method method : this.proxyFactory.getCachedMethods()) {
            this.addViewInterceptor(method, interceptorFactory, priority);
        }
    }

    public void addViewInterceptor(Method method, InterceptorFactory interceptorFactory, int priority) {
        OrderedItemContainer<Object> container = this.viewInterceptors.get(method);
        if (container == null) {
            container = new OrderedItemContainer();
            this.viewInterceptors.put(method, container);
        }
        container.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getClientInterceptors(Method method) {
        OrderedItemContainer<InterceptorFactory> container = this.clientInterceptors.get(method);
        if (container == null) {
            return Collections.emptyList();
        }
        return container.getSortedItems();
    }

    public void addClientInterceptor(InterceptorFactory interceptorFactory, int priority) {
        for (Method method : this.proxyFactory.getCachedMethods()) {
            this.addClientInterceptor(method, interceptorFactory, priority);
        }
    }

    public void addClientInterceptor(Method method, InterceptorFactory interceptorFactory, int priority) {
        OrderedItemContainer<Object> container = this.clientInterceptors.get(method);
        if (container == null) {
            container = new OrderedItemContainer();
            this.clientInterceptors.put(method, container);
        }
        container.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getClientPostConstructInterceptors() {
        return this.clientPostConstructInterceptors.getSortedItems();
    }

    public void addClientPostConstructInterceptor(InterceptorFactory interceptorFactory, int priority) {
        this.clientPostConstructInterceptors.add(interceptorFactory, priority);
    }

    public List<InterceptorFactory> getClientPreDestroyInterceptors() {
        return this.clientPreDestroyInterceptors.getSortedItems();
    }

    public void addClientPreDestroyInterceptor(InterceptorFactory interceptorFactory, int priority) {
        this.clientPreDestroyInterceptors.add(interceptorFactory, priority);
    }

    public ProxyFactory<?> getProxyFactory() {
        return this.proxyFactory;
    }

    public List<BindingConfiguration> getBindingConfigurations() {
        return this.bindingConfigurations;
    }

    public Class<?> getViewClass() {
        return this.viewClass;
    }

    public Set<Method> getAsyncMethods() {
        return Collections.unmodifiableSet(this.asyncMethods);
    }

    public void addAsyncMethod(Method method) {
        this.asyncMethods.add(method);
    }

    public ViewInstanceFactory getViewInstanceFactory() {
        return this.viewInstanceFactory;
    }

    public void setViewInstanceFactory(ViewInstanceFactory viewInstanceFactory) {
        this.viewInstanceFactory = viewInstanceFactory;
    }

    public <T> void putPrivateData(Class<T> type, T data) {
        this.privateData.put(type, data);
    }

    public Map<Class<?>, Object> getPrivateData() {
        return this.privateData;
    }
}

