/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.component.interceptors.InvocationType;
import org.jboss.as.naming.ManagedReference;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorContext;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InterceptorFactoryContext;
import org.jboss.msc.value.Value;

final class ManagedReferenceMethodInjectionInterceptorFactory
implements InterceptorFactory {
    private final Object targetContextKey;
    private final Object valueContextKey;
    private final Value<ManagedReferenceFactory> factoryValue;
    private final Method method;
    private final boolean optional;

    ManagedReferenceMethodInjectionInterceptorFactory(Object targetContextKey, Object valueContextKey, Value<ManagedReferenceFactory> factoryValue, Method method, boolean optional) {
        this.targetContextKey = targetContextKey;
        this.valueContextKey = valueContextKey;
        this.factoryValue = factoryValue;
        this.method = method;
        this.optional = optional;
    }

    public Interceptor create(InterceptorFactoryContext context) {
        Map contextData = context.getContextData();
        AtomicReference targetReference = (AtomicReference)contextData.get(this.targetContextKey);
        AtomicReference<ManagedReference> valueReference = new AtomicReference<ManagedReference>();
        contextData.put(this.valueContextKey, valueReference);
        return new ManagedReferenceMethodInjectionInterceptor(targetReference, valueReference, (ManagedReferenceFactory)this.factoryValue.getValue(), this.method, this.optional);
    }

    static final class ManagedReferenceMethodInjectionInterceptor
    implements Interceptor {
        private final AtomicReference<ManagedReference> targetReference;
        private final AtomicReference<ManagedReference> valueReference;
        private final ManagedReferenceFactory factory;
        private final Method method;
        private final boolean optional;

        ManagedReferenceMethodInjectionInterceptor(AtomicReference<ManagedReference> targetReference, AtomicReference<ManagedReference> valueReference, ManagedReferenceFactory factory, Method method, boolean optional) {
            this.targetReference = targetReference;
            this.valueReference = valueReference;
            this.factory = factory;
            this.method = method;
            this.optional = optional;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object processInvocation(InterceptorContext context) throws Exception {
            Object target;
            if (Modifier.isStatic(this.method.getModifiers())) {
                target = null;
            } else {
                target = this.targetReference.get().getInstance();
                if (target == null) {
                    throw EeMessages.MESSAGES.injectionTargetNotFound();
                }
            }
            ManagedReference reference = this.factory.getReference();
            if (reference == null && this.optional) {
                return context.proceed();
            }
            boolean ok = false;
            try {
                this.valueReference.set(reference);
                InvocationType invocationType = (InvocationType)((Object)context.getPrivateData(InvocationType.class));
                try {
                    context.putPrivateData(InvocationType.class, (Object)InvocationType.DEPENDENCY_INJECTION);
                    this.method.invoke(target, reference.getInstance());
                }
                finally {
                    context.putPrivateData(InvocationType.class, (Object)invocationType);
                }
                Object result = context.proceed();
                ok = true;
                Object object = result;
                return object;
            }
            finally {
                if (!ok) {
                    this.valueReference.set(null);
                    reference.release();
                }
            }
        }
    }
}

