/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.structure;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.ee.EeLogger;
import org.jboss.as.ee.EeMessages;
import org.jboss.as.ee.metadata.EJBClientDescriptorMetaData;
import org.jboss.as.ee.structure.Attachments;
import org.jboss.as.ee.structure.EJBClientDescriptor10Parser;
import org.jboss.as.ee.structure.EJBClientDescriptor11Parser;
import org.jboss.as.ee.structure.EJBClientDescriptor12Parser;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.modules.ModuleLoader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLMapper;
import org.jboss.vfs.VirtualFile;

public class EJBClientDescriptorParsingProcessor
implements DeploymentUnitProcessor {
    public static final String[] EJB_CLIENT_DESCRIPTOR_LOCATIONS = new String[]{"META-INF/jboss-ejb-client.xml", "WEB-INF/jboss-ejb-client.xml"};
    private static final QName ROOT_1_0 = new QName("urn:jboss:ejb-client:1.0", "jboss-ejb-client");
    private static final QName ROOT_1_1 = new QName("urn:jboss:ejb-client:1.1", "jboss-ejb-client");
    private static final QName ROOT_1_2 = new QName("urn:jboss:ejb-client:1.2", "jboss-ejb-client");
    private static final QName ROOT_NO_NAMESPACE = new QName("jboss-ejb-client");
    private static final XMLInputFactory INPUT_FACTORY = XMLInputFactory.newInstance();
    private final XMLMapper mapper = XMLMapper.Factory.create();

    public EJBClientDescriptorParsingProcessor() {
        this.mapper.registerRootElement(ROOT_1_0, (XMLElementReader)EJBClientDescriptor10Parser.INSTANCE);
        this.mapper.registerRootElement(ROOT_1_1, (XMLElementReader)EJBClientDescriptor11Parser.INSTANCE);
        this.mapper.registerRootElement(ROOT_1_2, (XMLElementReader)EJBClientDescriptor12Parser.INSTANCE);
        this.mapper.registerRootElement(ROOT_NO_NAMESPACE, (XMLElementReader)EJBClientDescriptor12Parser.INSTANCE);
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        File ejbClientDeploymentDescriptorFile;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ResourceRoot resourceRoot = (ResourceRoot)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.DEPLOYMENT_ROOT);
        ServiceModuleLoader moduleLoader = (ServiceModuleLoader)deploymentUnit.getAttachment(org.jboss.as.server.deployment.Attachments.SERVICE_MODULE_LOADER);
        VirtualFile descriptorFile = null;
        for (String loc : EJB_CLIENT_DESCRIPTOR_LOCATIONS) {
            VirtualFile file = resourceRoot.getRoot().getChild(loc);
            if (!file.exists()) continue;
            descriptorFile = file;
            break;
        }
        if (descriptorFile == null) {
            return;
        }
        if (deploymentUnit.getParent() != null) {
            EeLogger.ROOT_LOGGER.subdeploymentIgnored(descriptorFile.getPathName());
            return;
        }
        try {
            ejbClientDeploymentDescriptorFile = descriptorFile.getPhysicalFile();
        }
        catch (IOException e) {
            throw EeMessages.MESSAGES.failedToProcessEJBClientDescriptor(e);
        }
        EJBClientDescriptorMetaData ejbClientDescriptorMetaData = this.parse(ejbClientDeploymentDescriptorFile, deploymentUnit, (ModuleLoader)moduleLoader);
        EeLogger.ROOT_LOGGER.debugf("Successfully parsed jboss-ejb-client.xml for deployment unit %s", deploymentUnit);
        deploymentUnit.putAttachment(Attachments.EJB_CLIENT_METADATA, (Object)ejbClientDescriptorMetaData);
    }

    public void undeploy(DeploymentUnit context) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBClientDescriptorMetaData parse(File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        FileInputStream fis;
        try {
            fis = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            throw EeMessages.MESSAGES.failedToProcessEJBClientDescriptor(e);
        }
        try {
            EJBClientDescriptorMetaData eJBClientDescriptorMetaData = this.parse(fis, file, deploymentUnit, moduleLoader);
            return eJBClientDescriptorMetaData;
        }
        finally {
            EJBClientDescriptorParsingProcessor.safeClose(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EJBClientDescriptorMetaData parse(InputStream source, File file, DeploymentUnit deploymentUnit, ModuleLoader moduleLoader) throws DeploymentUnitProcessingException {
        EJBClientDescriptorMetaData eJBClientDescriptorMetaData;
        XMLInputFactory inputFactory = INPUT_FACTORY;
        this.setIfSupported(inputFactory, "javax.xml.stream.isValidating", Boolean.FALSE);
        this.setIfSupported(inputFactory, "javax.xml.stream.supportDTD", Boolean.FALSE);
        XMLStreamReader streamReader = inputFactory.createXMLStreamReader(source);
        try {
            EJBClientDescriptorMetaData result = new EJBClientDescriptorMetaData();
            this.mapper.parseDocument((Object)result, streamReader);
            eJBClientDescriptorMetaData = result;
        }
        catch (Throwable throwable) {
            try {
                EJBClientDescriptorParsingProcessor.safeClose(streamReader);
                throw throwable;
            }
            catch (XMLStreamException e) {
                throw EeMessages.MESSAGES.xmlErrorParsingEJBClientDescriptor(e, file.getAbsolutePath());
            }
        }
        EJBClientDescriptorParsingProcessor.safeClose(streamReader);
        return eJBClientDescriptorMetaData;
    }

    private void setIfSupported(XMLInputFactory inputFactory, String property, Object value) {
        if (inputFactory.isPropertySupported(property)) {
            inputFactory.setProperty(property, value);
        }
    }

    private static void safeClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void safeClose(XMLStreamReader streamReader) {
        if (streamReader != null) {
            try {
                streamReader.close();
            }
            catch (XMLStreamException xMLStreamException) {
                // empty catch block
            }
        }
    }
}

